/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.entity.entities;

import com.scouter.netherdepthsupgrade.entity.NDUEntity;
import com.scouter.netherdepthsupgrade.items.LavaFishingRodItem;
import com.scouter.netherdepthsupgrade.loot.NDULootTables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;

public class LavaFishingBobberEntity
extends FishingHook
implements IEntityWithComplexSpawn {
    private static final EntityDataAccessor<Integer> DATA_HOOKED_ENTITY = SynchedEntityData.defineId(LavaFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> DATA_BITING = SynchedEntityData.defineId(LavaFishingBobberEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private final RandomSource syncronizedRandom = RandomSource.create();
    private boolean bitingFish;
    private int luck;
    private int lureSpeed;
    private int life;
    private int nibble;
    private int timeUntilLured;
    private int timeUntilHooked;
    private int outOfLavaTime;
    private float fishAngle;
    private boolean openLava = true;
    @Nullable
    private Entity hookedEntity;
    private LavaFishingBobberEntityState currentState = LavaFishingBobberEntityState.FLYING;

    public LavaFishingBobberEntity(EntityType<? extends LavaFishingBobberEntity> entityType, Level level) {
        super(entityType, level);
    }

    public LavaFishingBobberEntity(Player p_37106_, Level level, int luck, int lureSpeed) {
        super(p_37106_, level, luck, lureSpeed);
        this.luck = Math.max(0, luck);
        this.lureSpeed = Math.max(0, lureSpeed);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_HOOKED_ENTITY.equals(pKey)) {
            int i = (Integer)this.getEntityData().get(DATA_HOOKED_ENTITY);
            Entity entity = this.hookedEntity = i > 0 ? this.level().getEntity(i - 1) : null;
        }
        if (DATA_BITING.equals(pKey)) {
            this.bitingFish = (Boolean)this.getEntityData().get(DATA_BITING);
            if (this.bitingFish) {
                this.setDeltaMovement(this.getDeltaMovement().x, -0.4f * Mth.nextFloat((RandomSource)this.random, (float)0.6f, (float)1.0f), this.getDeltaMovement().z);
            }
        }
        super.onSyncedDataUpdated(pKey);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_HOOKED_ENTITY, (Object)0);
        pBuilder.define(DATA_BITING, (Object)false);
    }

    private boolean shouldStopFishing(Player player) {
        ItemStack itemstack = player.getMainHandItem();
        ItemStack itemstack1 = player.getOffhandItem();
        boolean flag = itemstack.getItem() instanceof LavaFishingRodItem;
        boolean flag1 = itemstack1.getItem() instanceof LavaFishingRodItem;
        if (!player.isRemoved() && player.isAlive() && (flag || flag1) && !(this.distanceToSqr((Entity)player) > 1024.0)) {
            return false;
        }
        this.discard();
        return true;
    }

    public void tick() {
        this.syncronizedRandom.setSeed(this.getUUID().getLeastSignificantBits() ^ this.level().getGameTime());
        Player player = this.getPlayerOwner();
        if (player == null) {
            this.discard();
        } else if (this.level().isClientSide || !this.shouldStopFishing(player)) {
            boolean flag;
            if (this.onGround()) {
                ++this.life;
                if (this.life >= 1200) {
                    this.discard();
                    return;
                }
            } else {
                this.life = 0;
            }
            float f = 0.0f;
            BlockPos blockpos = this.blockPosition();
            FluidState fluidstate = this.level().getFluidState(blockpos);
            if (fluidstate.is(FluidTags.LAVA)) {
                f = fluidstate.getHeight((BlockGetter)this.level(), blockpos);
            }
            boolean bl = flag = f > 0.0f;
            if (this.currentState == LavaFishingBobberEntityState.FLYING) {
                if (this.hookedEntity != null) {
                    this.setDeltaMovement(Vec3.ZERO);
                    this.currentState = LavaFishingBobberEntityState.HOOKED_IN_ENTITY;
                    return;
                }
                if (flag) {
                    this.setDeltaMovement(this.getDeltaMovement().multiply(0.3, 0.2, 0.3));
                    this.currentState = LavaFishingBobberEntityState.BOBBING;
                    return;
                }
                this.checkCollision();
            } else {
                if (this.currentState == LavaFishingBobberEntityState.HOOKED_IN_ENTITY) {
                    if (this.hookedEntity != null) {
                        if (!this.hookedEntity.isRemoved() && this.hookedEntity.level().dimension() == this.level().dimension()) {
                            this.setPos(this.hookedEntity.getX(), this.hookedEntity.getY(0.8), this.hookedEntity.getZ());
                        } else {
                            this.setHookedEntity(null);
                            this.currentState = LavaFishingBobberEntityState.FLYING;
                        }
                    }
                    return;
                }
                if (this.currentState == LavaFishingBobberEntityState.BOBBING) {
                    Vec3 vec3 = this.getDeltaMovement();
                    double d0 = this.getY() + vec3.y - (double)blockpos.getY() - (double)f;
                    if (Math.abs(d0) < 0.01) {
                        d0 += Math.signum(d0) * 0.1;
                    }
                    this.setDeltaMovement(vec3.x * 0.9, vec3.y - d0 * (double)this.random.nextFloat() * 0.2, vec3.z * 0.9);
                    if (this.nibble <= 0 && this.timeUntilHooked <= 0) {
                        this.openLava = true;
                    } else {
                        boolean bl2 = this.openLava = this.openLava && this.outOfLavaTime < 10 && this.calculateOpenLava(blockpos);
                    }
                    if (flag) {
                        this.outOfLavaTime = Math.max(0, this.outOfLavaTime - 1);
                        if (this.bitingFish) {
                            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1 * (double)this.syncronizedRandom.nextFloat() * (double)this.syncronizedRandom.nextFloat(), 0.0));
                        }
                        if (!this.level().isClientSide) {
                            this.catchingFish(blockpos);
                        }
                    } else {
                        this.outOfLavaTime = Math.min(10, this.outOfLavaTime + 1);
                    }
                }
            }
            if (!fluidstate.is(FluidTags.LAVA)) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
            }
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.updateRotation();
            if (this.currentState == LavaFishingBobberEntityState.FLYING && (this.onGround() || this.horizontalCollision)) {
                this.setDeltaMovement(Vec3.ZERO);
            }
            double d1 = 0.92;
            this.setDeltaMovement(this.getDeltaMovement().scale(0.92));
            this.reapplyPosition();
        }
    }

    private void checkCollision() {
        HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity);
        if (hitresult.getType() == HitResult.Type.MISS || !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.onHit(hitresult);
        }
    }

    protected boolean canHitEntity(Entity p_37135_) {
        return super.canHitEntity(p_37135_) || p_37135_.isAlive() && p_37135_ instanceof ItemEntity;
    }

    protected void onHitEntity(EntityHitResult pResult) {
        super.onHitEntity(pResult);
        if (!this.level().isClientSide) {
            this.setHookedEntity(pResult.getEntity());
        }
    }

    protected void onHitBlock(BlockHitResult pResult) {
        super.onHitBlock(pResult);
        this.setDeltaMovement(this.getDeltaMovement().normalize().scale(pResult.distanceTo((Entity)this)));
    }

    private boolean calculateOpenLava(BlockPos p_37159_) {
        FishLavaType fishinghook$fishlavatype = FishLavaType.INVALID;
        for (int i = -1; i <= 2; ++i) {
            FishLavaType fishinghook$fishlavatype1 = this.getOpenLavaTypeForArea(p_37159_.offset(-2, i, -2), p_37159_.offset(2, i, 2));
            switch (fishinghook$fishlavatype1.ordinal()) {
                case 2: {
                    return false;
                }
                case 0: {
                    if (fishinghook$fishlavatype != FishLavaType.INVALID) break;
                    return false;
                }
                case 1: {
                    if (fishinghook$fishlavatype != FishLavaType.ABOVE_LAVA) break;
                    return false;
                }
            }
            fishinghook$fishlavatype = fishinghook$fishlavatype1;
        }
        return true;
    }

    private FishLavaType getOpenLavaTypeForArea(BlockPos p_37148_, BlockPos p_37149_) {
        return BlockPos.betweenClosedStream((BlockPos)p_37148_, (BlockPos)p_37149_).map(this::getOpenLavaTypeForBlock).reduce((p_37139_, p_37140_) -> p_37139_ == p_37140_ ? p_37139_ : FishLavaType.INVALID).orElse(FishLavaType.INVALID);
    }

    private FishLavaType getOpenLavaTypeForBlock(BlockPos p_37164_) {
        BlockState blockstate = this.level().getBlockState(p_37164_);
        if (!blockstate.isAir()) {
            FluidState fluidstate = blockstate.getFluidState();
            return fluidstate.is(FluidTags.LAVA) && fluidstate.isSource() && blockstate.getCollisionShape((BlockGetter)this.level(), p_37164_).isEmpty() ? FishLavaType.INSIDE_LAVA : FishLavaType.INVALID;
        }
        return FishLavaType.ABOVE_LAVA;
    }

    private void catchingFish(BlockPos p_37146_) {
        ServerLevel serverlevel = (ServerLevel)this.level();
        int i = 1;
        BlockPos blockpos = p_37146_.above();
        if (this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockpos)) {
            ++i;
        }
        if (this.random.nextFloat() < 0.5f && !this.level().canSeeSky(blockpos)) {
            --i;
        }
        if (this.nibble > 0) {
            --this.nibble;
            if (this.nibble <= 0) {
                this.timeUntilLured = 0;
                this.timeUntilHooked = 0;
                this.getEntityData().set(DATA_BITING, (Object)false);
            }
        } else if (this.timeUntilHooked > 0) {
            this.timeUntilHooked -= i;
            if (this.timeUntilHooked > 0) {
                this.fishAngle += (float)(this.random.nextGaussian() * 4.0);
                float f = this.fishAngle * ((float)Math.PI / 180);
                float f1 = Mth.sin((float)f);
                float f2 = Mth.cos((float)f);
                double d0 = this.getX() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                double d1 = (float)Mth.floor((double)this.getY()) + 1.0f;
                double d2 = this.getZ() + (double)(f2 * (float)this.timeUntilHooked * 0.1f);
                BlockState blockstate = serverlevel.getBlockState(BlockPos.containing((double)d0, (double)(d1 - 1.0), (double)d2));
                if (serverlevel.getBlockState(BlockPos.containing((double)((int)d0), (double)((int)d1 - 1), (double)((int)d2))).is(Blocks.LAVA)) {
                    if (this.random.nextFloat() < 0.15f) {
                        serverlevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                    }
                    float f3 = f1 * 0.04f;
                    float f4 = f2 * 0.04f;
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                }
            } else {
                this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                double d3 = this.getY() + 0.5;
                serverlevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                serverlevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                this.nibble = Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
                this.getEntityData().set(DATA_BITING, (Object)true);
            }
        } else if (this.timeUntilLured > 0) {
            this.timeUntilLured -= i;
            float f5 = 0.15f;
            if (this.timeUntilLured < 20) {
                f5 += (float)(20 - this.timeUntilLured) * 0.05f;
            } else if (this.timeUntilLured < 40) {
                f5 += (float)(40 - this.timeUntilLured) * 0.02f;
            } else if (this.timeUntilLured < 60) {
                f5 += (float)(60 - this.timeUntilLured) * 0.01f;
            }
            if (this.random.nextFloat() < f5) {
                float f6 = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                float f7 = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                double d4 = this.getX() + (double)(Mth.sin((float)f6) * f7) * 0.1;
                double d5 = (float)Mth.floor((double)this.getY()) + 1.0f;
                double d6 = this.getZ() + (double)(Mth.cos((float)f6) * f7) * 0.1;
                BlockState blockstate1 = serverlevel.getBlockState(BlockPos.containing((double)d4, (double)(d5 - 1.0), (double)d6));
                if (serverlevel.getBlockState(BlockPos.containing((double)d4, (double)(d5 - 1.0), (double)d6)).is(Blocks.LAVA)) {
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.LANDING_LAVA, d4, d5, d6, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                }
            }
            if (this.timeUntilLured <= 0) {
                this.fishAngle = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f);
                this.timeUntilHooked = Mth.nextInt((RandomSource)this.random, (int)20, (int)80);
            }
        } else {
            this.timeUntilLured = Mth.nextInt((RandomSource)this.random, (int)100, (int)600);
            this.timeUntilLured -= this.lureSpeed;
        }
    }

    public int retrieve(ItemStack p_37157_) {
        Player player = this.getPlayerOwner();
        if (!this.level().isClientSide && player != null && !this.shouldStopFishing(player)) {
            int i = 0;
            ItemFishedEvent event = null;
            if (this.hookedEntity != null) {
                this.pullEntity(this.hookedEntity);
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)player, p_37157_, (FishingHook)this, Collections.emptyList());
                this.level().broadcastEntityEvent((Entity)this, (byte)31);
                i = this.hookedEntity instanceof ItemEntity ? 3 : 5;
            } else if (this.nibble > 0) {
                LootParams lootparams = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)p_37157_).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.getOwner()).withLuck((float)this.luck + player.getLuck()).create(LootContextParamSets.FISHING);
                LootTable loottable = null;
                double d = (float)Math.floor(this.getBoundingBox().minY) + 1.0f;
                BlockState blockstate = this.level().getBlockState(BlockPos.containing((double)this.position().x, (double)(d - 1.0), (double)this.position().z));
                loottable = blockstate.is(Blocks.LAVA) ? (this.level().dimension() == Level.NETHER ? Objects.requireNonNull(this.level().getServer()).reloadableRegistries().getLootTable(NDULootTables.NETHER_FISHING) : Objects.requireNonNull(this.level().getServer()).reloadableRegistries().getLootTable(NDULootTables.LAVA_FISHING)) : Objects.requireNonNull(this.level().getServer()).reloadableRegistries().getLootTable(NDULootTables.FAILED_FISHING);
                if (loottable == null && event != null) {
                    this.discard();
                    return 0;
                }
                ObjectArrayList list = loottable.getRandomItems(lootparams);
                event = new ItemFishedEvent((List)list, this.onGround() ? 2 : 1, (FishingHook)this);
                NeoForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.discard();
                    return event.getRodDamage();
                }
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)player, p_37157_, (FishingHook)this, (Collection)list);
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this, this.level(), this.getX(), this.getY() + 1.0, this.getZ(), itemstack){

                        public boolean displayFireAnimation() {
                            return false;
                        }

                        public void lavaHurt() {
                        }
                    };
                    double d0 = player.getX() - this.getX();
                    double d1 = player.getY() - (this.getY() + 1.0);
                    double d2 = player.getZ() - this.getZ();
                    double d3 = 0.1;
                    itementity.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.level().addFreshEntity((Entity)itementity);
                    player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), player.getX(), player.getY() + 0.5, player.getZ() + 0.5, this.random.nextInt(6) + 1));
                    if (!itemstack.is(ItemTags.FISHES)) continue;
                    player.awardStat(Stats.FISH_CAUGHT, 1);
                }
                i = 1;
            }
            if (this.onGround()) {
                i = 2;
            }
            this.discard();
            return event == null ? i : event.getRodDamage();
        }
        return 0;
    }

    public void onClientRemoval() {
        this.updateOwnerInfo(null);
    }

    public void setOwner(@Nullable Entity pEntity) {
        super.setOwner(pEntity);
        this.updateOwnerInfo(this);
    }

    public void lerpTo(double pX, double pY, double pZ, float pYaw, float pPitch, int pPosRotationIncrements, boolean pTeleport) {
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = 64.0;
        return pDistance < 4096.0;
    }

    public void remove(Entity.RemovalReason pReason) {
        this.updateOwnerInfo(null);
        super.remove(pReason);
    }

    private void updateOwnerInfo(@Nullable LavaFishingBobberEntity p_150148_) {
        Player player = this.getPlayerOwner();
        if (player != null) {
            player.fishing = p_150148_;
        }
    }

    private void setHookedEntity(@Nullable Entity entity) {
        this.hookedEntity = entity;
        this.getEntityData().set(DATA_HOOKED_ENTITY, (Object)(entity == null ? 0 : entity.getId() + 1));
    }

    @Nonnull
    public EntityType<?> getType() {
        return (EntityType)NDUEntity.LAVA_BOBBER.get();
    }

    protected void pullEntity(Entity entityPulled) {
        Entity entity = this.getOwner();
        if (entity != null) {
            Vec3 vec3 = new Vec3(entity.getX() - this.getX(), entity.getY() - this.getY(), entity.getZ() - this.getZ()).scale(0.1);
            entityPulled.setDeltaMovement(entityPulled.getDeltaMovement().add(vec3));
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
    }

    static enum LavaFishingBobberEntityState {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }

    static enum FishLavaType {
        ABOVE_LAVA,
        INSIDE_LAVA,
        INVALID;

    }
}

