/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.datagen;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.scouter.netherdepthsupgrade.NetherDepthsUpgrade;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import org.slf4j.Logger;

public class SBlockStateGenerator
extends BlockStateProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final List<Pair<BooleanProperty, Function<ResourceLocation, Variant>>> MULTIFACE_GENERATOR = List.of(Pair.of((Object)BlockStateProperties.NORTH, p_176234_ -> Variant.variant().with(VariantProperties.MODEL, p_176234_)), Pair.of((Object)BlockStateProperties.EAST, p_176229_ -> Variant.variant().with(VariantProperties.MODEL, p_176229_).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.UV_LOCK, (Object)true)), Pair.of((Object)BlockStateProperties.SOUTH, p_176225_ -> Variant.variant().with(VariantProperties.MODEL, p_176225_).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180).with(VariantProperties.UV_LOCK, (Object)true)), Pair.of((Object)BlockStateProperties.WEST, p_176213_ -> Variant.variant().with(VariantProperties.MODEL, p_176213_).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.UV_LOCK, (Object)true)), Pair.of((Object)BlockStateProperties.UP, p_176204_ -> Variant.variant().with(VariantProperties.MODEL, p_176204_).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270).with(VariantProperties.UV_LOCK, (Object)true)), Pair.of((Object)BlockStateProperties.DOWN, p_176195_ -> Variant.variant().with(VariantProperties.MODEL, p_176195_).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90).with(VariantProperties.UV_LOCK, (Object)true)));
    public static BlockFamily family = null;
    static final Map<BlockFamily.Variant, BiConsumer<SBlockStateGenerator, Block>> SHAPE_CONSUMERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, SBlockStateGenerator::generateButton).put((Object)BlockFamily.Variant.DOOR, SBlockStateGenerator::generateDoor).put((Object)BlockFamily.Variant.CHISELED, SBlockStateGenerator::generateChiseled).put((Object)BlockFamily.Variant.CRACKED, SBlockStateGenerator::generateCracked).put((Object)BlockFamily.Variant.CUSTOM_FENCE, SBlockStateGenerator::generateFence).put((Object)BlockFamily.Variant.FENCE, SBlockStateGenerator::generateFence).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, SBlockStateGenerator::generateFenceGate).put((Object)BlockFamily.Variant.FENCE_GATE, SBlockStateGenerator::generateFenceGate).put((Object)BlockFamily.Variant.SIGN, SBlockStateGenerator::generateSign).put((Object)BlockFamily.Variant.SLAB, SBlockStateGenerator::generateSlab).put((Object)BlockFamily.Variant.STAIRS, SBlockStateGenerator::generateStair).put((Object)BlockFamily.Variant.PRESSURE_PLATE, SBlockStateGenerator::generatePressurePlate).put((Object)BlockFamily.Variant.TRAPDOOR, SBlockStateGenerator::generateTrapDoor).put((Object)BlockFamily.Variant.WALL, SBlockStateGenerator::generateWall).build();

    public SBlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "netherdepthsupgrade", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)NDUBlocks.LAVA_SPONGE.get());
        this.simpleBlock((Block)NDUBlocks.WET_LAVA_SPONGE.get());
        this.simpleBlock((Block)NDUBlocks.LAVA_GLASS.get());
    }

    private void createPottedPlant(DeferredBlock<Block> plant, DeferredBlock<Block> pottedPlant, String renderType) {
        ConfiguredModel cFfile = new ConfiguredModel(this.pottedPlant(this.name((Block)pottedPlant.get()), this.blockTexture((Block)plant.get()), renderType));
        this.getVariantBuilder((Block)pottedPlant.get()).partialState().setModels(new ConfiguredModel[]{cFfile});
    }

    public ModelFile pottedPlant(String name, ResourceLocation plant, String renderType) {
        return this.singleTexture(name, "block/flower_pot_cross", "plant", plant, renderType);
    }

    public void createFlatWaterEgg(Block block) {
        this.createFlatWaterEgg(block, "");
        this.flatWaterEgg(block);
        this.singleTexWaterEgg(block);
    }

    private BlockModelBuilder singleTexWaterEgg(Block block) {
        return this.generated(this.getName(block), ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)("item/" + this.getName(block))));
    }

    private void flatWaterEgg(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile(this.existingModel("eggs/" + this.getName(block))).build(), new Property[0]);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)("block/" + path));
    }

    public void createHangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.name(signBlock), texture);
        this.createHangingSignBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }

    public void createHangingSignBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private void logBlock(DeferredBlock<Block> block) {
        this.logBlock((Block)block.get());
    }

    private void logBlock(Block block) {
        this.axisBlock((RotatedPillarBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block).getPath()), NetherDepthsUpgrade.prefix("block/" + this.key(block).getPath() + "_top"));
    }

    private void createAge3Block(Block pBlock, String renderTyp, boolean item) {
        String baseName = this.name(pBlock);
        this.getVariantBuilder(pBlock).forAllStatesExcept(state -> {
            int age = (Integer)state.getValue((Property)BlockStateProperties.AGE_3);
            ResourceLocation textureSuspicious = NetherDepthsUpgrade.prefix("block/" + baseName + "_" + age);
            ModelFile text = this.cross(baseName + "_" + age, textureSuspicious, renderTyp);
            return ConfiguredModel.builder().modelFile(text).build();
        }, new Property[0]);
        ModelFile.ExistingModelFile file = this.models().getExistingFile(NetherDepthsUpgrade.prefix(baseName + "_0"));
        if (item) {
            this.simpleBlockItem(pBlock, (ModelFile)file);
        }
    }

    private void createCropBlock(Block pBlock, String renderTyp) {
        String baseName = this.name(pBlock);
        this.getVariantBuilder(pBlock).forAllStatesExcept(state -> {
            int age = (Integer)state.getValue((Property)CropBlock.AGE);
            ResourceLocation textureSuspicious = NetherDepthsUpgrade.prefix("block/" + baseName + "_" + age);
            ModelFile text = this.cross(baseName + "_" + age, textureSuspicious, renderTyp);
            return ConfiguredModel.builder().modelFile(text).build();
        }, new Property[0]);
        ModelFile.ExistingModelFile file = this.models().getExistingFile(NetherDepthsUpgrade.prefix(baseName + "_0"));
        this.simpleBlockItem(pBlock, (ModelFile)file);
    }

    private void createSkullBlocks(DeferredBlock<Block> deferredBlock) {
        Block block = (Block)deferredBlock.get();
        String baseName = this.name(block);
        this.getVariantBuilder(block).forAllStates(state -> {
            ResourceLocation skullLoc = NetherDepthsUpgrade.prefix("block/skulls/" + baseName);
            ModelFile.ExistingModelFile text = this.models().getExistingFile(skullLoc);
            return ConfiguredModel.builder().modelFile((ModelFile)text).build();
        });
        this.getVariantBuilder(this.getBlock(NetherDepthsUpgrade.prefix(baseName + "_wall"))).forAllStates(state -> {
            ResourceLocation skullLoc = NetherDepthsUpgrade.prefix("block/skulls/" + baseName + "_wall");
            ModelFile.ExistingModelFile text = this.models().getExistingFile(skullLoc);
            return ConfiguredModel.builder().modelFile((ModelFile)text).build();
        });
        this.singleTexItem(block);
        this.singleTexItem(this.getBlock(NetherDepthsUpgrade.prefix(baseName + "_wall")));
    }

    private void createBrushableBlock(Block pBlock) {
        String baseName = this.name(pBlock);
        this.getVariantBuilder(pBlock).forAllStatesExcept(state -> {
            int dusted = (Integer)state.getValue((Property)BlockStateProperties.DUSTED);
            ResourceLocation textureSuspicious = NetherDepthsUpgrade.prefix("block/" + baseName + "_" + dusted);
            ModelBuilder text = this.models().cubeAll(baseName + "_" + dusted, textureSuspicious);
            return ConfiguredModel.builder().modelFile((ModelFile)text).build();
        }, new Property[0]);
        ModelFile.ExistingModelFile file = this.models().getExistingFile(NetherDepthsUpgrade.prefix(baseName + "_0"));
        this.simpleBlockItem(pBlock, (ModelFile)file);
    }

    private void simpleBlockLeaves(DeferredBlock<Block> b, String renderType) {
        this.simpleBlock((Block)b.get(), this.leaves((Block)b.get(), renderType));
    }

    private void simpleBlock(DeferredBlock<Block> b, String renderType) {
        this.simpleBlock((Block)b.get(), this.cubeAll((Block)b.get(), renderType));
    }

    public void cubeAllWithItem(Block block, String renderType) {
        ModelFile file = this.cubeAll(this.name(block), this.blockTexture(block), renderType);
        this.simpleBlockItem(block, file);
    }

    public ModelFile cubeAll(Block block, String renderType) {
        return this.cubeAll(this.name(block), this.blockTexture(block), renderType);
    }

    public ModelFile leaves(Block block, String renderType) {
        ModelFile leaves = this.leaves(this.name(block), this.blockTexture(block), renderType);
        this.simpleBlockItem(block, leaves);
        return leaves;
    }

    public ModelFile leaves(String name, ResourceLocation texture, String renderType) {
        return this.singleTexture(name, "block/leaves", "all", texture, renderType);
    }

    public ModelFile cubeAll(String name, ResourceLocation texture, String renderType) {
        return this.singleTexture(name, "block/cube_all", "all", texture, renderType);
    }

    private void buildLamp(Block block) {
        String baseName = this.name(block);
        ResourceLocation textureOn = NetherDepthsUpgrade.prefix("block/" + baseName + "_on");
        ResourceLocation textureOff = NetherDepthsUpgrade.prefix("block/" + baseName + "_off");
        ModelBuilder on = this.models().cubeAll(baseName + "_on", textureOn);
        ModelBuilder off = this.models().cubeAll(baseName + "_off", textureOff);
        this.simpleBlockItem(block, (ModelFile)off);
        this.buildLamp(block, (ModelFile)on, (ModelFile)off);
    }

    private void buildLamp(Block block, ModelFile on, ModelFile off) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            boolean isLit = (Boolean)state.getValue((Property)BlockStateProperties.LIT);
            return ConfiguredModel.builder().modelFile(isLit ? on : off).build();
        }, new Property[0]);
    }

    public void generatePressurePlate(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.pressurePlateBlock((PressurePlateBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()));
    }

    public void generateWall(Block block) {
        this.wallBlockWithRenderType((WallBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block).getPath().replace("_wall", "")), "cutout");
        this.generatedWall(this.name(block), ResourceLocation.tryParse((String)this.blockTexture(block).toString().replace("_wall", "")));
    }

    public void generateTrapDoor(Block block) {
        this.trapdoorBlockWithRenderType((TrapDoorBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block).getPath()), true, "cutout");
    }

    public void generateStair(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.stairsBlockWithRenderType((StairBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()), "cutout");
    }

    public void generateSlab(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.slabBlock((SlabBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()), NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()), NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()), NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()));
    }

    public void generateSign(Block signBlock) {
        LOGGER.error("Sign gen is not yet implemented!");
        String p = this.key(signBlock).getPath();
        String z = p.replace("_sign", "_wall_sign").replace("blocks/", "");
        ResourceLocation hanging = NetherDepthsUpgrade.prefix(z);
        Block block = this.getBlock(hanging);
        this.signBlock((StandingSignBlock)signBlock, (WallSignBlock)block, NetherDepthsUpgrade.prefix("entity/sign/" + this.key(signBlock).getPath().replace("_sign", "")));
    }

    public void generateFenceGate(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.fenceGateBlockWithRenderType((FenceGateBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()), "cutout");
    }

    public void generateFence(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.fenceBlockWithRenderType((FenceBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()), "cutout");
    }

    public void generateCracked(Block block) {
        this.blockWithItem(block);
    }

    public void generateChiseled(Block block) {
        this.blockWithItem(block);
    }

    public void generateDoor(Block doorBlock) {
        this.doorBlockWithRenderType((DoorBlock)doorBlock, NetherDepthsUpgrade.prefix("block/" + this.key(doorBlock).getPath() + "_bottom"), NetherDepthsUpgrade.prefix("block/" + this.key(doorBlock).getPath() + "_top"), "cutout");
    }

    public void generateButton(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.buttonBlock((ButtonBlock)block, NetherDepthsUpgrade.prefix("block/" + this.key(block1).getPath()));
    }

    private void blockWithItem(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void blockWithItem(Block blockRegistryObject, ModelFile file) {
        this.simpleBlockWithItem(blockRegistryObject, file);
    }

    private void blockWithItem(Block blockRegistryObject) {
        this.simpleBlockWithItem(blockRegistryObject, this.cubeAll(blockRegistryObject));
    }

    private void blockWithItemSlab(Block blockRegistryObject) {
        this.simpleBlockWithItem(blockRegistryObject, this.stripSlab(blockRegistryObject));
    }

    private ModelFile stripSlab(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        return this.models().cubeAll(this.name(block), ResourceLocation.tryParse((String)this.blockTexture(block1).toString().replace("_slab", "")));
    }

    private void createWallFan(DeferredBlock<Block> b, String renderType) {
        ModelFile file = new ConfiguredModel((ModelFile)this.wallCoral((String)this.name((Block)((Block)b.get())), (ResourceLocation)this.blockTexture((Block)((Block)b.get())), (String)renderType)).model;
        this.getVariantBuilder((Block)b.get()).forAllStates(state -> ConfiguredModel.builder().modelFile(file).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build());
        this.simpleBlockItem((Block)b.get(), file);
    }

    private void createTintedCross(DeferredBlock<Block> b, String renderType) {
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(this.tintedCross(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType))});
    }

    public ModelFile tintedCross(String name, ResourceLocation cross, String renderType) {
        return this.singleTexture(name, "block/tinted_cross", "cross", cross, renderType);
    }

    private void createDoubleCross(DeferredBlock<Block> b, String renderType) {
        String baseName = this.name((Block)b.get());
        this.getVariantBuilder((Block)b.get()).forAllStatesExcept(e -> {
            DoubleBlockHalf val = (DoubleBlockHalf)e.getValue((Property)DoublePlantBlock.HALF);
            String mod = val == DoubleBlockHalf.LOWER ? "bottom" : "top";
            ResourceLocation texture = NetherDepthsUpgrade.prefix("block/" + baseName + "_" + mod);
            ModelFile text = this.cross(baseName + "_" + mod, texture, renderType);
            return ConfiguredModel.builder().modelFile(text).build();
        }, new Property[0]);
        this.singleTex((Block)b.get(), baseName + "_top");
    }

    private void createCross(DeferredBlock<Block> b, String renderType) {
        ConfiguredModel cFfile = new ConfiguredModel(this.cross(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType));
        ModelFile file = cFfile.model;
        String baseName = this.name((Block)b.get());
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{cFfile});
        this.singleTex((Block)b.get(), baseName);
    }

    public ModelFile cross(String name, ResourceLocation cross, String renderType) {
        return this.singleTexture(name, "block/cross", "cross", cross, renderType);
    }

    private ModelFile singleTexture(String name, String parent, String textureKey, ResourceLocation texture, String renderType) {
        return this.singleTexture(name, this.mcLoc(parent), textureKey, texture, renderType);
    }

    public ModelFile wallCoral(String name, ResourceLocation fan, String renderType) {
        return this.singleTexture(name, "block/coral_wall_fan", "fan", fan, renderType);
    }

    private void createCoralFan(DeferredBlock<Block> b, String renderType) {
        this.getVariantBuilder((Block)b.get()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel(this.coralFan(this.name((Block)b.get()), this.blockTexture((Block)b.get()), renderType))});
        this.singleTex((Block)b.get());
    }

    public ModelFile coralFan(String name, ResourceLocation fan, String renderType) {
        return this.singleTexture(name, "block/coral_fan", "fan", fan, renderType);
    }

    public ModelFile singleTexture(String name, ResourceLocation parent, String textureKey, ResourceLocation texture, String renderType) {
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture(textureKey, texture)).renderType(renderType);
    }

    private BlockModelBuilder generatedWall(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("block/" + name, "block/wall_inventory");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private BlockModelBuilder generatedSlab(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("block/" + name, "block/slab");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private void blockWithTop(DeferredBlock<Block> blockRegistryObject) {
        this.horizontalBlock((Block)blockRegistryObject.get(), NetherDepthsUpgrade.prefix("block/" + this.key((Block)blockRegistryObject.get()).getPath()), NetherDepthsUpgrade.prefix("block/" + this.key((Block)blockRegistryObject.get()).getPath()), NetherDepthsUpgrade.prefix("block/" + this.key((Block)blockRegistryObject.get()).getPath() + "_top"));
        this.simpleBlockItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private BlockModelBuilder singleTexItem(Block block, ResourceLocation name) {
        return this.generated(this.name(block), name);
    }

    private BlockModelBuilder singleTexItem(Block block) {
        return this.generated(this.name(block), ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)("item/" + this.name(block))));
    }

    private BlockModelBuilder singleTex(Block block) {
        return this.singleTex(block, this.name(block));
    }

    private BlockModelBuilder singleTex(Block block, String name) {
        return this.generated(this.name(block), ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)("block/" + name)));
    }

    private BlockModelBuilder generated(String name, ResourceLocation ... layers) {
        BlockModelBuilder builder = (BlockModelBuilder)this.models().withExistingParent("item/" + name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (BlockModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private String getName(Block block) {
        return this.key(block).toString().replace("netherdepthsupgrade:", "");
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public ModelFile createFlatWaterEgg(Block block, String modifier) {
        String baseName = this.getName(block);
        return this.models().singleTexture("block/eggs/" + modifier + baseName.replace("netherdepthsupgrade:", ""), ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)"block/template_eggs/template_flat_water_egg"), this.blockTextureEggs(block));
    }

    public ResourceLocation blockTextureEggs(Block block) {
        ResourceLocation name = this.key(block);
        return ResourceLocation.fromNamespaceAndPath((String)name.getNamespace(), (String)("block/eggs/" + name.getPath()));
    }

    private String name(Block block) {
        return this.key(block).getPath();
    }

    private Block getBlock(ResourceLocation resourceLocation) {
        return (Block)BuiltInRegistries.BLOCK.get(resourceLocation);
    }
}

