/*
 * Decompiled with CFR 0.152.
 */
package com.scouter.netherdepthsupgrade.datagen;

import com.google.common.collect.ImmutableMap;
import com.scouter.netherdepthsupgrade.NetherDepthsUpgrade;
import com.scouter.netherdepthsupgrade.blocks.NDUBlocks;
import com.scouter.netherdepthsupgrade.items.NDUItems;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.BlockFamily;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ItemModelGenerator
extends ItemModelProvider {
    public static BlockFamily family = null;
    static final Map<BlockFamily.Variant, BiConsumer<ItemModelGenerator, Block>> SHAPE_CONSUMERS = ImmutableMap.builder().put((Object)BlockFamily.Variant.BUTTON, ItemModelGenerator::toBlockButton).put((Object)BlockFamily.Variant.DOOR, ItemModelGenerator::singleTexBlockItem).put((Object)BlockFamily.Variant.CHISELED, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.CRACKED, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.CUSTOM_FENCE, ItemModelGenerator::toBlockFence).put((Object)BlockFamily.Variant.FENCE, ItemModelGenerator::toBlockFence).put((Object)BlockFamily.Variant.CUSTOM_FENCE_GATE, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.FENCE_GATE, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.SIGN, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.SLAB, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.STAIRS, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.PRESSURE_PLATE, ItemModelGenerator::toBlock).put((Object)BlockFamily.Variant.TRAPDOOR, ItemModelGenerator::toBlockTrapdoor).put((Object)BlockFamily.Variant.WALL, ItemModelGenerator::toBlockWall).build();

    public ItemModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "netherdepthsupgrade", existingFileHelper);
    }

    protected void registerModels() {
        for (Item i : BuiltInRegistries.ITEM) {
            if (!(i instanceof SpawnEggItem) || !BuiltInRegistries.ITEM.getKey((Object)i).getNamespace().equals("netherdepthsupgrade")) continue;
            ((ItemModelBuilder)this.getBuilder(BuiltInRegistries.ITEM.getKey((Object)i).getPath())).parent((ModelFile)this.getExistingFile(ResourceLocation.withDefaultNamespace((String)"item/template_spawn_egg")));
        }
        this.singleTex(NDUItems.LAVA_PUFFERFISH_BUCKET);
        this.singleTex(NDUItems.LAVA_PUFFERFISH);
        this.singleTex(NDUItems.OBSIDIANFISH);
        this.singleTex(NDUItems.OBSIDIANFISH_BUCKET);
        this.singleTex(NDUItems.SEARING_COD_BUCKET);
        this.singleTex(NDUItems.SEARING_COD);
        this.singleTex(NDUItems.BONEFISH_BUCKET);
        this.singleTex(NDUItems.BONEFISH);
        this.singleTex(NDUItems.WITHER_BONEFISH_BUCKET);
        this.singleTex(NDUItems.WITHER_BONEFISH);
        this.singleTex(NDUItems.BLAZEFISH_BUCKET);
        this.singleTex(NDUItems.BLAZEFISH);
        this.singleTex(NDUItems.MAGMACUBEFISH_BUCKET);
        this.singleTex(NDUItems.MAGMACUBEFISH);
        this.singleTex(NDUItems.GLOWDINE_BUCKET);
        this.singleTex(NDUItems.GLOWDINE);
        this.singleTex(NDUItems.SOULSUCKER_BUCKET);
        this.singleTex(NDUItems.SOULSUCKER);
        this.singleTex(NDUItems.SOUL_SUCKER_LEATHER);
        this.singleTex(NDUItems.FORTRESS_GROUPER);
        this.singleTex(NDUItems.FORTRESS_GROUPER_BUCKET);
        this.singleTex(NDUItems.EYEBALL_FISH);
        this.singleTex(NDUItems.EYEBALL_FISH_BUCKET);
        this.singleTex(NDUItems.FORTRESS_GROUPER_PLATE);
        this.singleTex(NDUItems.EYEBALL_FISH_EYE);
        this.toBlock(NDUBlocks.LAVA_SPONGE);
        this.toBlock(NDUBlocks.WET_LAVA_SPONGE);
        this.toBlock(NDUBlocks.WARPED_KELP_BLOCK);
        this.toBlock(NDUBlocks.WARPED_KELP_CARPET_BLOCK);
        this.toBlock(NDUBlocks.CRIMSON_KELP_BLOCK);
        this.toBlock(NDUBlocks.CRIMSON_KELP_CARPET_BLOCK);
        this.toBlock(NDUBlocks.LAVA_GLASS);
    }

    private ItemModelBuilder simpleItem(DeferredItem<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.withDefaultNamespace((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)("item/" + item.getId().getPath())));
    }

    private void toBlock(DeferredBlock<Block> b) {
        this.toBlockModel(b, b.getId().getPath());
    }

    private void toBlockWall(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.wallInventory(BuiltInRegistries.BLOCK.getKey((Object)block).toString(), NetherDepthsUpgrade.prefix("block/" + BuiltInRegistries.BLOCK.getKey((Object)block1).getPath()));
    }

    private void toBlockTrapdoor(Block b) {
        String s = BuiltInRegistries.BLOCK.getKey((Object)b).getPath();
        StringBuilder stringBuilder = new StringBuilder(s);
        stringBuilder.append("_bottom");
        this.toBlockModel(b, stringBuilder.toString());
    }

    private void toBlock(Block b) {
        this.toBlockModel(b, BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    private void toBlockItem(Block b) {
        this.toBlockModelItem(b, BuiltInRegistries.BLOCK.getKey((Object)b).getPath());
    }

    private void toBlockFence(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.fenceInventory(BuiltInRegistries.BLOCK.getKey((Object)block).toString(), NetherDepthsUpgrade.prefix("block/" + BuiltInRegistries.BLOCK.getKey((Object)block1).getPath()));
    }

    private void toBlockButton(Block block) {
        Block block1 = block;
        if (family != null) {
            block1 = family.getBaseBlock();
        }
        this.buttonInventory(BuiltInRegistries.BLOCK.getKey((Object)block).toString(), NetherDepthsUpgrade.prefix("block/" + BuiltInRegistries.BLOCK.getKey((Object)block1).getPath()));
    }

    private void toBlockModel(Block b, String model) {
        this.toBlockModel(b, NetherDepthsUpgrade.prefix("block/" + model));
    }

    private void toBlockModelItem(Block b, String model) {
        this.toBlockModel(b, NetherDepthsUpgrade.prefix("item/" + model));
    }

    private void toBlockModel(DeferredBlock<Block> b, String model) {
        this.toBlockModel(b, NetherDepthsUpgrade.prefix("block/" + model));
    }

    private void toBlockModel(DeferredBlock<Block> b, ResourceLocation model) {
        this.withExistingParent(b.getId().getPath(), model);
    }

    private ItemModelBuilder singleTex(DeferredItem<Item> item) {
        return this.generated(item.getId().getPath(), NetherDepthsUpgrade.prefix("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder singleTexFood(DeferredItem<Item> item) {
        return this.generated(item.getId().getPath(), NetherDepthsUpgrade.prefix("item/farmersdelight_compat_food/" + item.getId().getPath()));
    }

    private ItemModelBuilder singleTexBlockItem(Block item) {
        return this.generated(this.key(item).getPath(), NetherDepthsUpgrade.prefix("item/" + this.key(item).getPath()));
    }

    private ItemModelBuilder singleTexBlockItem(DeferredBlock<Block> item) {
        return this.generated(item.getId().getPath(), NetherDepthsUpgrade.prefix("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder singleTexBlock(DeferredBlock<Block> item) {
        return this.generated(item.getId().getPath(), NetherDepthsUpgrade.prefix("block/" + item.getId().getPath()));
    }

    private ItemModelBuilder generated(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/generated");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private ItemModelBuilder singleTexHandheld(DeferredItem<Item> item) {
        return this.generatedHandheld(item.getId().getPath(), NetherDepthsUpgrade.prefix("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder generatedHandheld(String name, ResourceLocation ... layers) {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(name, "item/handheld");
        for (int i = 0; i < layers.length; ++i) {
            builder = (ItemModelBuilder)builder.texture("layer" + i, layers[i]);
        }
        return builder;
    }

    private void toBlockModel(Block b, ResourceLocation model) {
        this.withExistingParent(BuiltInRegistries.BLOCK.getKey((Object)b).getPath(), model);
    }

    private ResourceLocation key(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }
}

