/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.tournament.Tournament;
import com.wdiscute.starcatcher.tournament.TournamentPlayerScore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TournamentOverlay
implements LayeredDraw.Layer {
    private static final Logger log = LoggerFactory.getLogger(TournamentOverlay.class);
    public static Tournament tournament;
    public static Map<UUID, String> gameProfilesCache;
    public static Pair<Component, Integer> firstPlace;
    public static Pair<Component, Integer> secondPlace;
    public static Pair<Component, Integer> thirdPlace;
    public static Pair<Component, Integer> playerPlace;
    public static ExpandedType expandedType;
    static int playerRank;
    private static final ResourceLocation BACKGROUND_TINY;
    private static final ResourceLocation BACKGROUND_EXPANDED;
    private static final ResourceLocation FIRST_PLACE_FISH;
    private static final ResourceLocation SECOND_PLACE_FISH;
    private static final ResourceLocation THIRD_PLACE_FISH;
    int uiX;
    int uiY;
    Font font;
    int imageWidth = 420;
    int imageHeight = 260;
    Player player;
    ClientLevel level;

    public static void clear() {
        tournament = null;
    }

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (tournament == null) {
            return;
        }
        if (Minecraft.getInstance().level == null) {
            return;
        }
        this.level = Minecraft.getInstance().level;
        if (Minecraft.getInstance().player == null) {
            return;
        }
        this.player = Minecraft.getInstance().player;
        this.uiX = Minecraft.getInstance().getWindow().getGuiScaledWidth() - this.imageWidth;
        this.uiY = Minecraft.getInstance().getWindow().getGuiScaledHeight() - this.imageHeight - 80;
        this.font = Minecraft.getInstance().font;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.0f);
        if (expandedType.equals((Object)ExpandedType.SMALL)) {
            this.renderImage(guiGraphics, BACKGROUND_TINY);
            guiGraphics.drawString(this.font, TournamentOverlay.tournament.name, 58, 35, 6508608, false);
            guiGraphics.drawString(this.font, (Component)playerPlace.getFirst(), 48, 70, -1, false);
            guiGraphics.drawString(this.font, String.valueOf(playerPlace.getSecond()), 160, 70, -1, false);
            guiGraphics.drawString(this.font, TournamentOverlay.getDisplayTimeLeft(TournamentOverlay.tournament.lastsUntilEpoch - System.currentTimeMillis()), 21, 35, -1, false);
            switch (playerRank) {
                case 1: {
                    guiGraphics.blit(FIRST_PLACE_FISH, 30, 72, 0.0f, 0.0f, 11, 6, 11, 6);
                }
                case 2: {
                    guiGraphics.blit(SECOND_PLACE_FISH, 30, 72, 0.0f, 0.0f, 11, 6, 11, 6);
                }
                case 3: {
                    guiGraphics.blit(THIRD_PLACE_FISH, 30, 72, 0.0f, 0.0f, 11, 6, 11, 6);
                }
            }
        } else if (expandedType.equals((Object)ExpandedType.BIG)) {
            this.renderImage(guiGraphics, BACKGROUND_EXPANDED);
            guiGraphics.drawString(this.font, TournamentOverlay.tournament.name, 58, 16, 6508608, false);
            if ((Integer)firstPlace.getSecond() != 0) {
                guiGraphics.drawString(this.font, (Component)firstPlace.getFirst(), 48, 71, -1, false);
            }
            if ((Integer)firstPlace.getSecond() != 0) {
                guiGraphics.drawString(this.font, String.valueOf(firstPlace.getSecond()), 154, 71, -1, false);
            }
            if ((Integer)secondPlace.getSecond() != 0) {
                guiGraphics.drawString(this.font, (Component)secondPlace.getFirst(), 48, 92, -1, false);
            }
            if ((Integer)secondPlace.getSecond() != 0) {
                guiGraphics.drawString(this.font, String.valueOf(secondPlace.getSecond()), 154, 92, -1, false);
            }
            if ((Integer)thirdPlace.getSecond() != 0) {
                guiGraphics.drawString(this.font, (Component)thirdPlace.getFirst(), 48, 113, -1, false);
            }
            if ((Integer)thirdPlace.getSecond() != 0) {
                guiGraphics.drawString(this.font, String.valueOf(thirdPlace.getSecond()), 154, 113, -1, false);
            }
            guiGraphics.drawString(this.font, (Component)playerPlace.getFirst(), 48, 141, -1, false);
            guiGraphics.drawString(this.font, String.valueOf(playerPlace.getSecond()), 154, 141, -1, false);
            guiGraphics.drawString(this.font, TournamentOverlay.getDisplayTimeLeft(TournamentOverlay.tournament.lastsUntilEpoch - System.currentTimeMillis()), 12, 31, -1, false);
            if (playerRank != 0) {
                guiGraphics.blit(switch (playerRank) {
                    case 1 -> FIRST_PLACE_FISH;
                    case 2 -> SECOND_PLACE_FISH;
                    default -> THIRD_PLACE_FISH;
                }, 30, 142, 0.0f, 0.0f, 11, 6, 11, 6);
            }
        }
        guiGraphics.pose().popPose();
    }

    public static String getDisplayTimeLeft(long ticks) {
        long ticksRemainingToCalculate = ticks / 1000L;
        if (ticksRemainingToCalculate < 0L) {
            return "????";
        }
        Object finalString = "";
        if (ticksRemainingToCalculate > 86400L) {
            finalString = (String)finalString + ticksRemainingToCalculate / 86400L + "d";
            return finalString;
        }
        if (ticksRemainingToCalculate > 3600L) {
            finalString = (String)finalString + String.format("%02d", ticksRemainingToCalculate / 3600L) + ":";
            finalString = (String)finalString + String.format("%02d", (ticksRemainingToCalculate %= 3600L) / 60L);
            return finalString;
        }
        finalString = (String)finalString + String.format("%02d", ticksRemainingToCalculate / 60L) + ":";
        finalString = (String)finalString + String.format("%02d", ticksRemainingToCalculate %= 60L);
        return finalString;
    }

    public static void onTournamentReceived(Tournament t, List<GameProfile> list) {
        list.forEach(e -> gameProfilesCache.put(e.getId(), e.getName()));
        firstPlace = Pair.of((Object)Component.literal((String)""), (Object)0);
        secondPlace = Pair.of((Object)Component.literal((String)""), (Object)0);
        thirdPlace = Pair.of((Object)Component.literal((String)""), (Object)0);
        if (t.status.equals((Object)Tournament.Status.ACTIVE)) {
            for (TournamentPlayerScore tps : t.playerScores) {
                if (tps.score > (Integer)thirdPlace.getSecond()) {
                    thirdPlace = Pair.of((Object)Component.literal((String)gameProfilesCache.get(tps.playerUUID)), (Object)tps.score);
                }
                if (tps.score > (Integer)secondPlace.getSecond()) {
                    thirdPlace = secondPlace;
                    secondPlace = Pair.of((Object)Component.literal((String)gameProfilesCache.get(tps.playerUUID)), (Object)tps.score);
                }
                if (tps.score <= (Integer)firstPlace.getSecond()) continue;
                secondPlace = firstPlace;
                firstPlace = Pair.of((Object)Component.literal((String)gameProfilesCache.get(tps.playerUUID)), (Object)tps.score);
            }
            Optional<TournamentPlayerScore> optional = t.playerScores.stream().filter(p -> p.playerUUID.equals(Minecraft.getInstance().player.getUUID())).findFirst();
            optional.ifPresent(playerScore -> {
                playerPlace = Pair.of((Object)Minecraft.getInstance().player.getName(), (Object)playerScore.score);
            });
            playerRank = ((Component)firstPlace.getFirst()).equals(playerPlace.getFirst()) ? 1 : (((Component)secondPlace.getFirst()).equals(playerPlace.getFirst()) ? 2 : (((Component)thirdPlace.getFirst()).equals(playerPlace.getFirst()) ? 3 : 0));
        }
        tournament = t;
    }

    private void renderImage(GuiGraphics guiGraphics, ResourceLocation rl) {
        guiGraphics.blit(rl, 0, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
    }

    static {
        gameProfilesCache = new HashMap<UUID, String>();
        firstPlace = Pair.of((Object)Component.literal((String)"[empty]"), (Object)0);
        secondPlace = Pair.of((Object)Component.literal((String)"[empty]"), (Object)0);
        thirdPlace = Pair.of((Object)Component.literal((String)"[empty]"), (Object)0);
        playerPlace = Pair.of((Object)Component.empty(), (Object)0);
        expandedType = ExpandedType.BIG;
        playerRank = 0;
        BACKGROUND_TINY = Starcatcher.rl("textures/gui/tournament/overlay_tiny.png");
        BACKGROUND_EXPANDED = Starcatcher.rl("textures/gui/tournament/overlay_expanded.png");
        FIRST_PLACE_FISH = Starcatcher.rl("textures/gui/tournament/first_place_fish.png");
        SECOND_PLACE_FISH = Starcatcher.rl("textures/gui/tournament/second_place_fish.png");
        THIRD_PLACE_FISH = Starcatcher.rl("textures/gui/tournament/third_place_fish.png");
    }

    public static enum ExpandedType {
        SMALL,
        BIG,
        HIDDEN;

        private static final ExpandedType[] vals;

        public ExpandedType previous() {
            if (this.ordinal() == 0) {
                return vals[vals.length - 1];
            }
            return vals[(this.ordinal() - 1) % vals.length];
        }

        public ExpandedType next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = ExpandedType.values();
        }
    }
}

