/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.io.ExtraComposites;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.tournament.TournamentPlayerScore;
import com.wdiscute.starcatcher.tournament.TournamentSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public class Tournament {
    public UUID tournamentUUID;
    public String name;
    public Status status;
    public UUID owner;
    public List<TournamentPlayerScore> playerScores;
    public TournamentSettings settings;
    public List<SingleStackContainer> lootPool;
    public long lastsUntilEpoch;
    public static final Tournament DEFAULT = new Tournament(UUID.randomUUID(), "missingno", Status.SETUP, UUID.randomUUID(), new ArrayList<TournamentPlayerScore>(), TournamentSettings.DEFAULT, new ArrayList<SingleStackContainer>(), 0L);
    public static final Codec<Tournament> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("tournament_uuid").forGetter(t -> t.tournamentUUID), (App)Codec.STRING.optionalFieldOf("name", (Object)"Unnamed Tournament").forGetter(t -> t.name), (App)Status.CODEC.fieldOf("status").forGetter(t -> t.status), (App)UUIDUtil.CODEC.fieldOf("owner").forGetter(t -> t.owner), (App)TournamentPlayerScore.CODEC.listOf().fieldOf("player_scores").forGetter(t -> t.playerScores), (App)TournamentSettings.CODEC.fieldOf("settings").forGetter(t -> t.settings), (App)SingleStackContainer.LIST_CODEC.optionalFieldOf("loot_pool", SingleStackContainer.EMPTY_LIST).forGetter(t -> t.lootPool), (App)Codec.LONG.fieldOf("lastsUntil").forGetter(t -> t.lastsUntilEpoch)).apply((Applicative)instance, Tournament::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Tournament> STREAM_CODEC = ExtraComposites.composite(UUIDUtil.STREAM_CODEC, t -> t.tournamentUUID, ByteBufCodecs.STRING_UTF8, t -> t.name, Status.STREAM_CODEC, t -> t.status, UUIDUtil.STREAM_CODEC, t -> t.owner, TournamentPlayerScore.STREAM_CODEC.apply(ByteBufCodecs.list()), t -> t.playerScores, TournamentSettings.STREAM_CODEC, t -> t.settings, SingleStackContainer.STREAM_CODEC_LIST, t -> t.lootPool, ByteBufCodecs.VAR_LONG, t -> t.lastsUntilEpoch, Tournament::new);

    public Tournament(UUID tournamentUUID, String name, Status status, UUID owner, List<TournamentPlayerScore> playerScore, TournamentSettings settings, List<SingleStackContainer> pool, long lastsUntil) {
        this.tournamentUUID = tournamentUUID;
        this.name = name;
        this.status = status;
        this.owner = owner;
        this.playerScores = playerScore;
        this.settings = settings;
        this.lootPool = pool;
        this.lastsUntilEpoch = lastsUntil;
    }

    public static Tournament empty(UUID uuid) {
        return new Tournament(uuid, "Unnamed Tournament", Status.SETUP, null, new ArrayList<TournamentPlayerScore>(), new TournamentSettings(TournamentSettings.Scoring.SIMPLE, 48000L, 0.0f, 0, SingleStackContainer.EMPTY_LIST), SingleStackContainer.EMPTY_LIST, 200L);
    }

    public Tournament setOwner(UUID owner) {
        this.owner = owner;
        this.playerScores.add(TournamentPlayerScore.empty(owner));
        return this;
    }

    public static enum Status implements StringRepresentable
    {
        SETUP("gui.starcatcher.tournament.status.setup"),
        ACTIVE("gui.starcatcher.tournament.status.active"),
        CANCELLED("gui.starcatcher.tournament.status.cancelled"),
        FINISHED("gui.starcatcher.tournament.status.finished");

        public static final Codec<Status> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, Status> STREAM_CODEC;
        private final String key;

        private Status(String name) {
            this.key = name;
        }

        public String toString() {
            return this.key;
        }

        public String getSerializedName() {
            return this.key;
        }

        public boolean isDone() {
            return this == FINISHED || this == CANCELLED;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Status::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Status.class);
        }
    }
}

