/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.tournament;

import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.registry.ModMenuTypes;
import com.wdiscute.starcatcher.registry.blocks.ModBlocks;
import com.wdiscute.starcatcher.registry.blocks.StandBlockEntity;
import com.wdiscute.starcatcher.tournament.Tournament;
import com.wdiscute.starcatcher.tournament.TournamentHandler;
import com.wdiscute.starcatcher.tournament.TournamentPlayerScore;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class StandMenu
extends AbstractContainerMenu {
    public final StandBlockEntity sbe;
    public final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 0;

    public StandMenu(int containerId, Inventory inv, BlockEntity blockEntity) {
        super(ModMenuTypes.STAND_MENU.get(), containerId);
        this.sbe = (StandBlockEntity)blockEntity;
        this.level = inv.player.level();
        int i = 0;
        while (i < 9) {
            final int slotid = i++;
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.sbe.entryCost, slotid, 210 + slotid * 16, 157){

                public boolean mayPickup(Player playerIn) {
                    if (StandMenu.this.level.isClientSide) {
                        return false;
                    }
                    StandMenu.this.sbe.entryCost.setStackInSlot(slotid, ItemStack.EMPTY);
                    StandMenu.this.sbe.tournament.settings.entryCost = SingleStackContainer.fromItemStackHandler(StandMenu.this.sbe.entryCost);
                    return false;
                }

                public boolean mayPlace(ItemStack stackInHand) {
                    if (StandMenu.this.level.isClientSide) {
                        return false;
                    }
                    StandMenu.this.sbe.entryCost.setStackInSlot(slotid, stackInHand.copy());
                    StandMenu.this.sbe.tournament.settings.entryCost = SingleStackContainer.fromItemStackHandler(StandMenu.this.sbe.entryCost);
                    return false;
                }
            });
        }
    }

    public StandMenu(int containerId, Inventory inv, FriendlyByteBuf extraData) {
        this(containerId, inv, inv.player.level().getBlockEntity(extraData.readBlockPos()));
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.level.isClientSide) {
            return false;
        }
        if (this.sbe.tournament.status == Tournament.Status.SETUP) {
            if (id == 101 && this.sbe.tournament.settings.durationInTicks > 1200L) {
                this.sbe.tournament.settings.durationInTicks -= 1200L;
            }
            if (id == 102 && this.sbe.tournament.settings.durationInTicks > 12000L) {
                this.sbe.tournament.settings.durationInTicks -= 12000L;
            }
            if (id == 103) {
                this.sbe.tournament.settings.durationInTicks += 1200L;
            }
            if (id == 104) {
                this.sbe.tournament.settings.durationInTicks += 12000L;
            }
            if (id == 68 && player.getUUID().equals(this.sbe.tournament.owner) && this.sbe.tournament.status.equals((Object)Tournament.Status.SETUP)) {
                TournamentHandler.startTournament(player, this.sbe.tournament);
            }
            if (id == 67 && this.sbe.tournament.settings.canSignUp(player) && !this.sbe.tournament.playerScores.stream().anyMatch(t -> t.playerUUID.equals(player.getUUID()))) {
                this.sbe.tournament.playerScores.add(TournamentPlayerScore.empty(player.getUUID()));
                List<SingleStackContainer> entryCost = this.sbe.tournament.settings.entryCost;
                if (!entryCost.isEmpty()) {
                    block0: for (SingleStackContainer ssc : entryCost) {
                        Predicate<ItemStack> predicate = is -> is.is(ssc.stack().getItem()) && is.getCount() >= ssc.stack().getCount();
                        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                            ItemStack is2 = player.getInventory().getItem(i);
                            if (!predicate.test(is2)) continue;
                            is2.shrink(ssc.stack().getCount());
                            continue block0;
                        }
                    }
                }
            }
        }
        if (id == 69 && player.getUUID().equals(this.sbe.tournament.owner) && this.sbe.tournament.status.equals((Object)Tournament.Status.ACTIVE)) {
            TournamentHandler.cancelTournament(this.level, this.sbe.tournament);
        }
        if (id == 53 && this.sbe.tournament.status.isDone()) {
            Tournament tournamentOld = this.sbe.tournament;
            this.sbe.setUuid(UUID.randomUUID());
            this.sbe.tournament = null;
            this.sbe.tournament = this.sbe.makeOrGetTournament().setOwner(tournamentOld.owner);
        }
        this.sbe.sync();
        return super.clickMenuButton(player, id);
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (!sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 36, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 36) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return StandMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.sbe.getBlockPos()), (Player)player, (Block)((Block)ModBlocks.STAND.get()));
    }
}

