/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.secretnotes;

import com.mojang.serialization.Codec;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.secretnotes.SecretNoteScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import org.jetbrains.annotations.NotNull;

public class SecretNote
extends Item {
    public SecretNote() {
        super(new Item.Properties().stacksTo(1).component(ModDataComponents.SECRET_NOTE, (Object)Note.SAMPLE_NOTE));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            this.openScreen((Note)((Object)ModDataComponents.get(player.getItemInHand(usedHand), ModDataComponents.SECRET_NOTE)));
        }
        return super.use(level, player, usedHand);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen(Note note) {
        Minecraft.getInstance().setScreen((Screen)new SecretNoteScreen(note));
    }

    public static enum Note implements StringRepresentable
    {
        SAMPLE_NOTE("sample_note"),
        CRYSTAL_HOOK("crystal_hook"),
        ARNWULF_1("lava_proof_bottle_1"),
        ARNWULF_2("lava_proof_bottle_2"),
        HOPEFUL_NOTE("hopeful_note"),
        HOPELESS_NOTE("hopeless_note"),
        WITHER("wither_note"),
        TRUE_BLUE("true_blue");

        public static final Codec<Note> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Note> STREAM_CODEC;
        private final String key;

        private Note(String key) {
            this.key = key;
        }

        @NotNull
        public String getSerializedName() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Note::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Note.class);
        }
    }
}

