/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.rod;

import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.io.ModDataAttachments;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.io.attachments.FishingBobAttachment;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ModTackleSkins;
import com.wdiscute.starcatcher.rod.FishingRodMenu;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import org.jetbrains.annotations.Nullable;

public class StarcatcherFishingRodItem
extends Item
implements MenuProvider {
    public StarcatcherFishingRodItem() {
        super(new Item.Properties().rarity(Rarity.EPIC).fireResistant().stacksTo(1).component((DataComponentType)ModDataComponents.BOBBER.get(), (Object)new SingleStackContainer(new ItemStack((ItemLike)ModItems.BOBBER.get()))).component((DataComponentType)ModDataComponents.BAIT.get(), (Object)SingleStackContainer.EMPTY).component((DataComponentType)ModDataComponents.HOOK.get(), (Object)new SingleStackContainer(new ItemStack((ItemLike)ModItems.HOOK.get()))));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack is;
        block5: {
            FishingBobAttachment fishingBobAttachment;
            block4: {
                is = player.getItemInHand(hand);
                if (!is.is(StarcatcherTags.RODS)) {
                    return InteractionResultHolder.pass((Object)is);
                }
                fishingBobAttachment = ModDataAttachments.get((Entity)player, ModDataAttachments.FISHING_BOB.get());
                if (player.isCrouching() && fishingBobAttachment.isEmpty()) {
                    player.openMenu((MenuProvider)this);
                    return InteractionResultHolder.success((Object)is);
                }
                if (level.isClientSide) {
                    return InteractionResultHolder.success((Object)is);
                }
                if (!fishingBobAttachment.isEmpty()) break block4;
                ModTackleSkins.get(player.level(), player.getItemInHand(hand)).onCast(player);
                if (!(level instanceof ServerLevel)) break block5;
                FishingBobEntity entity = new FishingBobEntity(level, player, is);
                level.addFreshEntity((Entity)entity);
                entity.lookAt(EntityAnchorArgument.Anchor.EYES, new Vec3(player.getX(), entity.getEyeY(), player.getZ()));
                fishingBobAttachment.setUuid((AttachmentHolder)player, entity.getUUID());
                if (!ModDataComponents.has(is, ModDataComponents.TACKLE_SKIN)) break block5;
                ModDataAttachments.set((Entity)entity, ModDataAttachments.TACKLE_SKIN.get(), (ResourceLocation)ModDataComponents.get(is, ModDataComponents.TACKLE_SKIN));
                break block5;
            }
            List entities = level.getEntities(null, new AABB(-25.0, -65.0, -25.0, 25.0, 65.0, 25.0).move(player.position()));
            for (Entity entity : entities) {
                FishingBobEntity fbe;
                if (!entity.getUUID().equals(fishingBobAttachment.getUuid()) || !(entity instanceof FishingBobEntity) || (fbe = (FishingBobEntity)entity).checkBiting()) continue;
                ModTackleSkins.get(player.level(), player.getItemInHand(hand)).onRetrieve(player);
                fbe.kill();
                ModDataAttachments.remove((Entity)player, ModDataAttachments.FISHING_BOB.get());
            }
        }
        return InteractionResultHolder.success((Object)is);
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.copy();
    }

    public Component getDisplayName() {
        return Component.literal((String)"");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        if (player.getMainHandItem().is(StarcatcherTags.RODS)) {
            return new FishingRodMenu(i, inventory, player.getMainHandItem());
        }
        return new FishingRodMenu(i, inventory, player.getOffhandItem());
    }
}

