/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.items.cheater;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.io.FishCaughtCounter;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import com.wdiscute.starcatcher.io.network.FishCaughtPayload;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class AwardOneFish
extends Item {
    public AwardOneFish() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (!player.isCreative()) {
            return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
        }
        if (level.isClientSide()) {
            return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
        }
        Map<ResourceLocation, FishCaughtCounter> fishesCaught = FishingGuideAttachment.getFishesCaught(player);
        Optional optional = level.registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY).getRandom(level.random);
        if (optional.isPresent()) {
            if (((Holder.Reference)optional.get()).is(U.rl("minecraft", "nether_star"))) {
                return InteractionResultHolder.pass((Object)player.getItemInHand(usedHand));
            }
            FishProperties fp = (FishProperties)((Holder.Reference)optional.get()).value();
            fishesCaught.putIfAbsent(U.getRlFromFp(level, fp), FishCaughtCounter.createHacked());
            if (player instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)player;
                PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new FishCaughtPayload(fp, false, 0, 0, 0.0f), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        FishingGuideAttachment.sync(player);
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }
}

