/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.fishing;

import com.mojang.datafixers.util.Pair;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.registry.fishing.compat.DGTrophies;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class TrophyPropertiesRegistry {
    private static final List<Pair<ResourceKey<TrophyProperties>, TrophyProperties>> PROPERTIES = new ArrayList<Pair<ResourceKey<TrophyProperties>, TrophyProperties>>();
    private static final List<ResourceKey<TrophyProperties>> COMPAT_KEYS = new ArrayList<ResourceKey<TrophyProperties>>();

    public static void register() {
        DGTrophies.bootstrap();
    }

    public static void registerConditions(BiConsumer<ResourceKey<?>, ICondition> consumer) {
        for (ResourceKey<TrophyProperties> compatKey : COMPAT_KEYS) {
            consumer.accept(compatKey, (ICondition)new ModLoadedCondition(compatKey.location().getNamespace()));
        }
    }

    private static ResourceKey<TrophyProperties> createKey(TrophyProperties tp) {
        return ResourceKey.create(Starcatcher.TROPHY_REGISTRY, (ResourceLocation)tp.fish().getKey().location());
    }

    protected static void registerTrophy(TrophyProperties.Builder builder) {
        TrophyProperties entry = builder.build();
        ResourceKey<TrophyProperties> key = TrophyPropertiesRegistry.createKey(entry);
        PROPERTIES.add((Pair<ResourceKey<TrophyProperties>, TrophyProperties>)Pair.of(key, (Object)entry));
        String namespace = key.location().getNamespace();
        if (!namespace.equals("minecraft") && !namespace.equals("starcatcher")) {
            COMPAT_KEYS.add(key);
        }
    }

    public static void bootstrap(BootstrapContext<TrophyProperties> context) {
        PROPERTIES.forEach(p -> context.register((ResourceKey)p.getFirst(), (Object)((TrophyProperties)p.getSecond())));
    }
}

