/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.fishing;

import com.mojang.datafixers.util.Pair;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.fishing.DGMinecraftFishes;
import com.wdiscute.starcatcher.registry.fishing.DGStarcatcherFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGAlexsCavesFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGAquacultureFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGAquamiraeFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGBetterEndFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGCollectorsReapFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGCrittersAndCompanionsFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGEnvironmentalFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGFintasticFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGFishOfThievesFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGHybridAquaticFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGMinersDelightFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGNetherDepthsUpgradeFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGSpawnFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGSullysModFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGTerraFirmaCraftFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGTideFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGUnusualFishFishes;
import com.wdiscute.starcatcher.registry.fishing.compat.DGUpgradeAquaticFishes;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class FishingPropertiesRegistry {
    private static final List<Pair<ResourceKey<FishProperties>, FishProperties>> PROPERTIES = new ArrayList<Pair<ResourceKey<FishProperties>, FishProperties>>();
    private static final List<ResourceKey<FishProperties>> COMPAT_KEYS = new ArrayList<ResourceKey<FishProperties>>();

    public static void register() {
        DGMinecraftFishes.bootstrap();
        DGStarcatcherFishes.bootstrap();
        DGTideFishes.bootstrap();
        DGAquacultureFishes.bootstrap();
        DGFishOfThievesFishes.bootstrap();
        DGNetherDepthsUpgradeFishes.bootstrap();
        DGSullysModFishes.bootstrap();
        DGUpgradeAquaticFishes.bootstrap();
        DGEnvironmentalFishes.bootstrap();
        DGBetterEndFishes.bootstrap();
        DGCollectorsReapFishes.bootstrap();
        DGMinersDelightFishes.bootstrap();
        DGAlexsCavesFishes.bootstrap();
        DGCrittersAndCompanionsFishes.bootstrap();
        DGHybridAquaticFishes.bootstrap();
        DGAquamiraeFishes.bootstrap();
        DGTerraFirmaCraftFishes.bootstrap();
        DGUnusualFishFishes.bootstrap();
        DGSpawnFishes.bootstrap();
        DGFintasticFishes.bootstrap();
    }

    public static FishProperties.Builder fish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish);
    }

    public static FishProperties.Builder overworldFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD);
    }

    public static FishProperties.Builder endFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.END);
    }

    public static FishProperties.Builder endOuterIslandsFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.END_OUTER_ISLANDS);
    }

    public static FishProperties.Builder netherLavaFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER_LAVA);
    }

    public static FishProperties.Builder netherLavaCrimsonForestFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER_LAVA_CRIMSON_FOREST);
    }

    public static FishProperties.Builder netherLavaWarpedForestFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER_LAVA_WARPED_FOREST);
    }

    public static FishProperties.Builder netherLavaSoulSandValleyFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER_LAVA_SOUL_SAND_VALLEY);
    }

    public static FishProperties.Builder netherLavaBasaltDeltasFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER_LAVA_BASALT_DELTAS);
    }

    public static FishProperties.Builder overworldLushCavesFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LUSH_CAVES).withBaitRestrictions(FishProperties.BaitRestrictions.LUSH_BAIT);
    }

    public static FishProperties.Builder overworldDeepDarkFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DEEP_DARK).withBaitRestrictions(FishProperties.BaitRestrictions.SCULK_BAIT);
    }

    public static FishProperties.Builder overworldSurfaceFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_SURFACE);
    }

    public static FishProperties.Builder overworldSurfaceLava(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAVA_SURFACE);
    }

    public static FishProperties.Builder overworldCavesFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_STONE_CAVES);
    }

    public static FishProperties.Builder overworldDripstoneCavesFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DRIPSTONE_CAVES).withBaitRestrictions(FishProperties.BaitRestrictions.DRIPSTONE_BAIT);
    }

    public static FishProperties.Builder overworldUndergroundFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_UNDERGROUND);
    }

    public static FishProperties.Builder overworldUndergroundLava(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAVA_UNDERGROUND);
    }

    public static FishProperties.Builder overworldMountainFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAKE.withMustBeCaughtAboveY(100).withMustBeCaughtBelowY(Integer.MAX_VALUE));
    }

    public static FishProperties.Builder overworldDeepslateFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DEEPSLATE);
    }

    public static FishProperties.Builder overworldDeepslateLava(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAVA_DEEPSLATE);
    }

    public static FishProperties.Builder overworldColdLakeFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_LAKE);
    }

    public static FishProperties.Builder overworldWarmLakeFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_LAKE);
    }

    public static FishProperties.Builder overworldWarmMountainFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_LAKE);
    }

    public static FishProperties.Builder overworldColdMountainFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_MOUNTAIN);
    }

    public static FishProperties.Builder overworldColdOceanFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_OCEAN);
    }

    public static FishProperties.Builder overworldColdRiverFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_COLD_RIVER);
    }

    public static FishProperties.Builder overworldLakeFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_LAKE);
    }

    public static FishProperties.Builder overworldOceanFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_ALL_OCEANS);
    }

    public static FishProperties.Builder overworldWarmOceanFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_WARM_OCEAN);
    }

    public static FishProperties.Builder overworldDeepOceanFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DEEP_OCEAN);
    }

    public static FishProperties.Builder overworldRiverFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_RIVER);
    }

    public static FishProperties.Builder overworldBeachFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_BEACH);
    }

    public static FishProperties.Builder overworldMushroomFieldsFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_MUSHROOM_FIELDS);
    }

    public static FishProperties.Builder overworldJungleFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_JUNGLE);
    }

    public static FishProperties.Builder overworldTaigaFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_TAIGA);
    }

    public static FishProperties.Builder overworldCherryGroveFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_CHERRY_GROVE).withBaitRestrictions(FishProperties.BaitRestrictions.CHERRY_BAIT);
    }

    public static FishProperties.Builder overworldSwampFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_SWAMPS).withBaitRestrictions(FishProperties.BaitRestrictions.MURKWATER_BAIT);
    }

    public static FishProperties.Builder overworldDarkForestFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_DARK_FOREST);
    }

    public static FishProperties.Builder overworldForestFish(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_FOREST);
    }

    public static FishProperties.Builder overworldVoidFishing(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.OVERWORLD_VOID);
    }

    public static FishProperties.Builder netherVoidFishing(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.NETHER_VOID);
    }

    public static FishProperties.Builder endVoidFishing(Holder<Item> fish) {
        return FishProperties.builder().withFish(fish).withWorldRestrictions(FishProperties.WorldRestrictions.END_VOID);
    }

    static ResourceKey<FishProperties> createKey(FishProperties fp) {
        return ResourceKey.create(Starcatcher.FISH_REGISTRY, (ResourceLocation)ResourceLocation.parse((String)fp.catchInfo().fish().getRegisteredName()));
    }

    public static void registerStarcatcherBucketAndEntity(FishProperties.Builder builder) {
        builder.withBucketedFish((Holder<Item>)ModItems.STARCAUGHT_BUCKET);
        builder.withEntityToSpawn(U.holderEntity("starcatcher", "fish"));
        DGStarcatcherFishes.STARCATCHER_FISHES.add(builder.build());
        FishingPropertiesRegistry.register(builder);
    }

    public static void registerStarcatcherOnlyEntity(FishProperties.Builder builder) {
        builder.withEntityToSpawn(U.holderEntity("starcatcher", "fish"));
        FishingPropertiesRegistry.register(builder);
    }

    public static void register(FishProperties.Builder builder) {
        FishProperties properties = builder.build();
        ResourceKey<FishProperties> key = FishingPropertiesRegistry.createKey(properties);
        PROPERTIES.add((Pair<ResourceKey<FishProperties>, FishProperties>)Pair.of(key, (Object)properties));
        String namespace = key.location().getNamespace();
        if (!namespace.equals("minecraft") && !namespace.equals("starcatcher")) {
            COMPAT_KEYS.add(key);
        }
    }

    public static void registerConditions(BiConsumer<ResourceKey<?>, ICondition> consumer) {
        for (ResourceKey<FishProperties> compatKey : COMPAT_KEYS) {
            if (compatKey.location().getNamespace().equals("hybrid-aquatic")) {
                consumer.accept(compatKey, (ICondition)new ModLoadedCondition("hybrid_aquatic"));
                continue;
            }
            consumer.accept(compatKey, (ICondition)new ModLoadedCondition(compatKey.location().getNamespace()));
        }
    }

    public static void bootstrap(BootstrapContext<FishProperties> context) {
        PROPERTIES.forEach(p -> context.register((ResourceKey)p.getFirst(), (Object)((FishProperties)p.getSecond())));
    }
}

