/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.tackleskin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.bob.FishingBobModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractTackleSkin {
    RenderType renderType = null;
    protected FishingBobModel<FishingBobEntity> model;

    public abstract ModelLayerLocation getLayerLocation();

    public abstract ResourceLocation getTexture();

    public void renderTackle(EntityRendererProvider.Context context, FishingBobEntity fishingBobEntity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (this.renderType == null) {
            this.model = new FishingBobModel(context.bakeLayer(this.getLayerLocation()));
            this.renderType = RenderType.entityCutout((ResourceLocation)this.getTexture());
        }
        this.model.renderToBuffer(poseStack, buffer.getBuffer(this.renderType), packedLight, OverlayTexture.NO_OVERLAY, -1);
    }

    public void onCast(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (player.level().getRandom().nextFloat() * 0.4f + 0.8f));
    }

    public void onRetrieve(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (player.level().getRandom().nextFloat() * 0.4f + 0.8f));
    }

    public void onMissed(Player player) {
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (player.level().getRandom().nextFloat() * 0.4f + 0.8f));
    }

    public void onSuccessfulMinigame(Player player) {
        Vec3 p = player.position();
        if (((Boolean)Config.ENABLE_VILLAGER_SOUND.get()).booleanValue()) {
            player.level().playSound(null, p.x, p.y, p.z, SoundEvents.VILLAGER_CELEBRATE, SoundSource.AMBIENT);
        }
    }

    public void onFailedMinigame(Player player) {
        Vec3 p = player.position();
        if (((Boolean)Config.ENABLE_VILLAGER_SOUND.get()).booleanValue()) {
            player.level().playSound(null, p.x, p.y, p.z, SoundEvents.VILLAGER_NO, SoundSource.AMBIENT);
        }
    }
}

