/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.minigamemodifiers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.minigame.ActiveSweetSpot;
import com.wdiscute.starcatcher.minigame.FishingMinigameScreen;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AbstractMinigameModifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class Nikdo53Modifier
extends AbstractMinigameModifier {
    public static final ResourceLocation POINTER_SMALL = Starcatcher.rl("textures/gui/minigame/modifiers/nikdo53_pointer_1.png");
    public static final ResourceLocation POINTER_LARGE = Starcatcher.rl("textures/gui/minigame/modifiers/nikdo53_pointer_2.png");
    public static final ResourceLocation WHEEL = Starcatcher.rl("textures/gui/minigame/modifiers/nikdo53_wheel.png");
    public int pointerLayer = 0;
    public int maxPointerLayer;
    public boolean isHoldingLeft = false;
    public boolean isHoldingRight = false;
    Options options;

    public Nikdo53Modifier() {
        this.options = Minecraft.getInstance().options;
        this.maxPointerLayer = 1;
    }

    public Nikdo53Modifier(int maxPointerLayer) {
        this.options = Minecraft.getInstance().options;
        this.maxPointerLayer = maxPointerLayer;
    }

    @Override
    public boolean onHit(ActiveSweetSpot spot) {
        if (Nikdo53Modifier.getSpotLayer(spot) == this.pointerLayer) {
            Nikdo53Modifier.putSpotLayer(spot, this.getRandomLayer());
            return super.onHit(spot);
        }
        return true;
    }

    @Override
    public void onKeyReleased(int key, int scanCode, int keyModifiers) {
        if (key == this.options.keyLeft.getKey().getValue()) {
            this.isHoldingLeft = false;
        }
        if (key == this.options.keyRight.getKey().getValue()) {
            this.isHoldingRight = false;
        }
    }

    @Override
    public void onKeyPress(int key, int scanCode, int keyModifiers) {
        if (key == this.options.keyLeft.getKey().getValue()) {
            --this.pointerLayer;
            this.isHoldingLeft = true;
        }
        if (key == this.options.keyRight.getKey().getValue()) {
            ++this.pointerLayer;
            this.isHoldingRight = true;
        }
        if (this.pointerLayer > this.maxPointerLayer) {
            this.pointerLayer = this.maxPointerLayer;
        }
        if (this.pointerLayer < 0) {
            this.pointerLayer = 0;
        }
    }

    @Override
    public ActiveSweetSpot onSpotAdded(ActiveSweetSpot spot) {
        int layer = this.getRandomLayer();
        Nikdo53Modifier.putSpotLayer(spot, layer);
        return super.onSpotAdded(spot);
    }

    private int getRandomLayer() {
        return Minecraft.getInstance().level.getRandom().nextIntBetweenInclusive(0, this.maxPointerLayer);
    }

    @Override
    public void renderOnPointer(GuiGraphics guiGraphics, PoseStack poseStack, float partialTick) {
        if (this.pointerLayer == 0) {
            FishingMinigameScreen.renderPoseCentered(guiGraphics, POINTER_SMALL, 128);
        } else {
            FishingMinigameScreen.renderPoseCentered(guiGraphics, POINTER_LARGE, 128);
        }
    }

    @Override
    public void renderOnSweetSpot(GuiGraphics guiGraphics, PoseStack poseStack, ActiveSweetSpot spot, float partialTick) {
        if (spot.behaviour == null) {
            return;
        }
        poseStack.pushPose();
        int layer = Nikdo53Modifier.getSpotLayer(spot);
        poseStack.translate(0.0f, (float)(-9 * layer), 0.0f);
        if (this.pointerLayer != layer) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        spot.behaviour.render(guiGraphics, poseStack, partialTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @Override
    public void renderBackground(GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.renderBackground(guiGraphics, partialTick, width, height);
        PoseStack poseStack = guiGraphics.pose();
        guiGraphics.blit(FishingMinigameScreen.TEXTURE, width / 2 - 40, height / 2 + 40, 32, 16, this.isHoldingLeft ? 32.0f : 0.0f, 128.0f, 32, 16, 256, 256);
        guiGraphics.blit(FishingMinigameScreen.TEXTURE, width / 2 + 8, height / 2 + 40, 32, 16, this.isHoldingRight ? 32.0f : 0.0f, 144.0f, 32, 16, 256, 256);
        poseStack.pushPose();
        poseStack.translate((float)(width >> 1), (float)(height >> 1), 0.0f);
        if (this.pointerLayer != 1) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        FishingMinigameScreen.renderPoseCentered(guiGraphics, WHEEL, 128);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @Override
    public boolean disablePointerRendering() {
        return true;
    }

    @Override
    public boolean disableSweetSpotRendering(ActiveSweetSpot spot) {
        return true;
    }

    private static int getSpotLayer(ActiveSweetSpot spot) {
        return (Integer)spot.extraData.get(53);
    }

    private static void putSpotLayer(ActiveSweetSpot spot, int layer) {
        spot.extraData.put(53, layer);
    }
}

