/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.custom.minigamemodifiers;

import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.minigame.FishingMinigameScreen;
import com.wdiscute.starcatcher.registry.custom.minigamemodifiers.AbstractTimedModifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.sounds.SoundEvents;

public class FrozenPointerWhileActiveModifier
extends AbstractTimedModifier {
    private final int rampTime;

    public FrozenPointerWhileActiveModifier(int length, int rampTime) {
        super(length);
        this.length = length;
        this.rampTime = rampTime;
    }

    @Override
    public void onAdd(FishingMinigameScreen instance) {
        super.onAdd(instance);
        Minecraft.getInstance().player.playSound(SoundEvents.GLASS_BREAK, 0.4f, 1.0f);
        Minecraft.getInstance().player.playSound(SoundEvents.SNOW_BREAK, 1.0f, 1.0f);
    }

    @Override
    public void tick() {
        super.tick();
        float currentSpeed = this.instance.pointerSpeed;
        float decreaseTime = Math.abs(this.instance.pointerBaseSpeed) / (float)this.rampTime;
        if (this.tickCount <= this.rampTime) {
            float f = this.instance.pointerSpeed = Math.abs(currentSpeed) < decreaseTime ? 0.0f : currentSpeed - Math.signum(currentSpeed) * decreaseTime;
        }
        if (this.tickCount >= this.length - this.rampTime) {
            float newPointerSpeed = currentSpeed + (float)U.sign(currentSpeed) * decreaseTime;
            this.instance.pointerSpeed = Math.abs(this.instance.pointerBaseSpeed) < newPointerSpeed ? this.instance.pointerBaseSpeed : newPointerSpeed;
        }
    }

    @Override
    public void onRemove() {
        super.onRemove();
        this.instance.pointerSpeed = this.instance.pointerBaseSpeed;
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, float partialTick, int width, int height) {
        super.renderForeground(guiGraphics, partialTick, width, height);
        guiGraphics.blit(FishingMinigameScreen.TEXTURE, width / 2 - 16, height / 2 - 16, 32, 32, 0.0f, 0.0f, 32, 32, 256, 256);
    }
}

