/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks.display;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBlock;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBlockEntity;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBookModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class DisplayBlockRenderer
implements BlockEntityRenderer<DisplayBlockEntity> {
    private final DisplayBookModel bookModel;

    public DisplayBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.bookModel = new DisplayBookModel(context.bakeLayer(DisplayBookModel.LAYER_LOCATION));
    }

    public void render(DisplayBlockEntity be, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BlockState blockstate = be.getBlockState();
        if (((Boolean)blockstate.getValue((Property)DisplayBlock.HAS_BOOK)).booleanValue()) {
            float rotDiff;
            poseStack.pushPose();
            float ticks = (float)be.time + partialTick;
            float openPartial = Math.clamp(be.open + partialTick * (0.1f * Math.signum(be.open - be.oOpen)), 0.0f, 1.0f);
            poseStack.translate(0.5f, 0.95f + 0.2f * Math.clamp(openPartial * 4.0f, 0.0f, 1.0f), 0.5f);
            poseStack.translate(0.0f, (0.1f + Mth.sin((float)(ticks / 10.0f * 0.6f)) * 0.03f) * openPartial, 0.0f);
            double rotation = be.rot + (be.rot - be.oRot) * partialTick;
            if (Math.abs(be.rot - be.oRot) > 3.0f) {
                rotation = be.rot;
            }
            double x = Math.cos(rotation);
            double y = Math.sin(rotation);
            poseStack.translate(x / 3.0 * (double)openPartial + -x / 5.0 * (double)(1.0f - openPartial), 0.0, y / 3.0 * (double)openPartial + -y / 5.0 * (double)(1.0f - openPartial));
            for (rotDiff = be.rot - be.oRot; rotDiff >= (float)Math.PI; rotDiff -= (float)Math.PI * 2) {
            }
            while (rotDiff < (float)(-Math.PI)) {
                rotDiff += (float)Math.PI * 2;
            }
            float f2 = be.oRot + rotDiff * partialTick;
            poseStack.mulPose(Axis.YP.rotation(-f2));
            poseStack.mulPose(Axis.ZP.rotationDegrees(30.0f * Math.clamp(openPartial * 2.0f, 0.0f, 1.0f)));
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f * (1.0f - Math.clamp(openPartial * 2.0f, 0.0f, 1.0f))));
            float f3 = Mth.lerp((float)partialTick, (float)be.oFlip, (float)be.flip);
            float f4 = Mth.frac((float)(f3 + 0.25f)) * 1.6f - 0.3f;
            float f5 = Mth.frac((float)(f3 + 0.75f)) * 1.6f - 0.3f;
            float f6 = Mth.lerp((float)partialTick, (float)be.oOpen, (float)openPartial);
            this.bookModel.setupAnim(ticks, Mth.clamp((float)f4, (float)0.0f, (float)1.0f), Mth.clamp((float)f5, (float)0.0f, (float)1.0f), f6);
            VertexConsumer vertexconsumer = buffer.getBuffer(this.bookModel.renderType(Starcatcher.rl("textures/entity/book.png")));
            this.bookModel.render(poseStack, vertexconsumer, packedLight, packedOverlay, -1);
            poseStack.popPose();
        }
    }

    public AABB getRenderBoundingBox(DisplayBlockEntity blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)((float)pos.getX() + 1.0f), (double)((float)pos.getY() + 1.5f), (double)((float)pos.getZ() + 1.0f));
    }
}

