/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks.display;

import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.registry.blocks.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DisplayBlockEntity
extends BlockEntity {
    ItemStack book = ItemStack.EMPTY;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;

    public static void bookAnimationTick(Level level, BlockPos pos, BlockState state, DisplayBlockEntity enchantingTable) {
        float f2;
        enchantingTable.oOpen = enchantingTable.open;
        enchantingTable.oRot = enchantingTable.rot;
        Player player = level.getNearestPlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.getX() - ((double)pos.getX() + 0.5);
            double d1 = player.getZ() - ((double)pos.getZ() + 0.5);
            enchantingTable.tRot = (float)Mth.atan2((double)d1, (double)d0);
            enchantingTable.open += 0.1f;
            if (enchantingTable.open < 0.5f || U.r.nextInt(40) == 0) {
                float f1 = enchantingTable.flipT;
                do {
                    enchantingTable.flipT += (float)(U.r.nextInt(4) - U.r.nextInt(4));
                } while (f1 == enchantingTable.flipT);
            }
        } else {
            enchantingTable.open -= 0.1f;
        }
        while (enchantingTable.rot >= (float)Math.PI) {
            enchantingTable.rot -= (float)Math.PI * 2;
        }
        while (enchantingTable.rot < (float)(-Math.PI)) {
            enchantingTable.rot += (float)Math.PI * 2;
        }
        while (enchantingTable.tRot >= (float)Math.PI) {
            enchantingTable.tRot -= (float)Math.PI * 2;
        }
        while (enchantingTable.tRot < (float)(-Math.PI)) {
            enchantingTable.tRot += (float)Math.PI * 2;
        }
        for (f2 = enchantingTable.tRot - enchantingTable.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        enchantingTable.rot += f2 * 0.4f;
        enchantingTable.open = Mth.clamp((float)enchantingTable.open, (float)0.0f, (float)1.0f);
        ++enchantingTable.time;
        enchantingTable.oFlip = enchantingTable.flip;
        float f = (enchantingTable.flipT - enchantingTable.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.clamp((float)f, (float)-0.2f, (float)0.2f);
        enchantingTable.flipA += (f - enchantingTable.flipA) * 0.9f;
        enchantingTable.flip += enchantingTable.flipA;
    }

    public DisplayBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.DISPLAY.get(), pos, blockState);
    }

    public ItemStack getBook() {
        return this.book;
    }

    public void setBook(ItemStack stack) {
        this.book = stack;
        this.setChanged();
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.book = tag.contains("Book", 10) ? ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("Book")).orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.getBook().isEmpty()) {
            tag.put("Book", this.getBook().save(registries));
        }
    }
}

