/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks.display;

import com.mojang.serialization.MapCodec;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBlockEntity;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class DisplayBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<DisplayBlock> CODEC = DisplayBlock.simpleCodec(DisplayBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty HAS_BOOK = BlockStateProperties.HAS_BOOK;
    public static final VoxelShape SHAPE_BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape SHAPE_POST = Block.box((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    public static final VoxelShape SHAPE_TOP_PLATE = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final VoxelShape SHAPE = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape[])new VoxelShape[]{SHAPE_POST, SHAPE_TOP_PLATE});

    public MapCodec<DisplayBlock> codec() {
        return CODEC;
    }

    public DisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
    }

    public DisplayBlock() {
        super(BlockBehaviour.Properties.of());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, HAS_BOOK, BlockStateProperties.WATERLOGGED});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ModBlockEntities.DISPLAY.get().create(pos, state);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            if (((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue()) {
                this.popBook(state, level, pos);
            }
            super.onRemove(state, level, pos, newState, isMoving);
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                level.updateNeighborsAt(pos.below(), (Block)this);
            }
        }
    }

    private void popBook(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LecternBlockEntity) {
            LecternBlockEntity lecternblockentity = (LecternBlockEntity)blockEntity;
            ItemStack itemstack = lecternblockentity.getBook().copy();
            ItemEntity itementity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, itemstack);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
            lecternblockentity.clearContent();
        }
    }

    protected boolean isSignalSource(BlockState state) {
        return true;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return side == Direction.UP && (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState blockState, Level level, BlockPos pos) {
        BlockEntity blockentity;
        if (((Boolean)blockState.getValue((Property)HAS_BOOK)).booleanValue() && (blockentity = level.getBlockEntity(pos)) instanceof LecternBlockEntity) {
            return ((LecternBlockEntity)blockentity).getRedstoneSignal();
        }
        return 0;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue() && !stack.isEmpty()) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue() && stack.is(ModItems.GUIDE)) {
            BlockEntity blockEntity2;
            if (!level.isClientSide && (blockEntity2 = level.getBlockEntity(pos)) instanceof DisplayBlockEntity) {
                DisplayBlockEntity dbe = (DisplayBlockEntity)blockEntity2;
                dbe.setBook(stack.consumeAndReturn(1, (LivingEntity)player));
                level.playSound(null, pos, SoundEvents.BOOK_PUT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(true)));
            return ItemInteractionResult.SUCCESS;
        }
        if (stack.isEmpty() && ((Boolean)state.getValue((Property)HAS_BOOK)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof DisplayBlockEntity) {
            DisplayBlockEntity dbe = (DisplayBlockEntity)blockEntity;
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_BOOK, (Comparable)Boolean.valueOf(false)));
            player.addItem(dbe.getBook());
            dbe.setBook(ItemStack.EMPTY);
            level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.2f, ((level.random.nextFloat() - level.random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.getValue((Property)HAS_BOOK) == false ? null : super.getMenuProvider(state, level, pos);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? DisplayBlock.createTickerHelper(blockEntityType, ModBlockEntities.DISPLAY.get(), DisplayBlockEntity::bookAnimationTick) : null;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

