/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks.Telescope;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Vector2d;
import org.lwjgl.glfw.GLFW;
import oshi.util.tuples.Pair;

public class TelescopeScreen
extends Screen {
    List<FishProperties> stars = new ArrayList<FishProperties>();
    double offsetX = 2700.0;
    double offsetY = 900.0;
    int frames = 0;
    int fps = 999;
    int ticks = 0;
    Pair<Double, Double> cacheOffset = new Pair((Object)0.0, (Object)0.0);
    boolean omouseLocked = true;
    boolean mouseLocked = true;
    float zoomScale;
    float vanillaScale = (float)Minecraft.getInstance().getWindow().getGuiScale();

    protected TelescopeScreen(Component title) {
        super(title);
        this.stars.addAll(Minecraft.getInstance().level.registryAccess().registryOrThrow(Starcatcher.FISH_REGISTRY).stream().filter(o -> !o.star().equals(FishProperties.Star.DEFAULT)).toList());
        float vanillaScale = (float)Minecraft.getInstance().getWindow().getGuiScale();
        this.zoomScale = 1.0f / vanillaScale;
        this.zoomScale += 2.0f;
        for (int i = 0; i < 36; ++i) {
            for (int j = 0; j < 48; ++j) {
                FishProperties.Star star = FishProperties.Star.fromRaAndDec("wda", j / 2, j % 2 == 0 ? 30 : 0, 0.0, -90 + i * 5, -90 + i * 5 > 0 ? 0x55FFFF00 : 0x55FF00FF, new String[0]);
                FishProperties fishProperties = FishProperties.builder().withStar(star).build();
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        ++this.frames;
        this.lockCursor();
        int screenHeight = Minecraft.getInstance().getWindow().getScreenHeight();
        int screenWidth = Minecraft.getInstance().getWindow().getScreenWidth();
        int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        PoseStack pose = guiGraphics.pose();
        guiGraphics.fill(0, 0, width, height, -16777216);
        pose.pushPose();
        pose.translate((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        guiGraphics.pose().scale(this.zoomScale / this.vanillaScale, this.zoomScale / this.vanillaScale, this.zoomScale / this.vanillaScale);
        int number = 0;
        for (FishProperties fp : this.stars) {
            FishProperties.Star star = fp.star();
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 3; ++j) {
                    double x = (double)star.x() - this.offsetX;
                    x += (double)(3600 * i);
                    double y = (double)star.y() - this.offsetY;
                    y += (double)(1800 * j);
                    if (j % 2 != 0) {
                        x -= 1800.0;
                    }
                    if (x > (double)((float)screenWidth / this.zoomScale / 2.0f) || x < (double)((float)(-screenWidth) / this.zoomScale / 2.0f) || y > (double)((float)screenHeight / this.zoomScale / 2.0f) || y < (double)((float)(-screenHeight) / this.zoomScale / 2.0f)) continue;
                    pose.pushPose();
                    pose.translate(x, y, 0.0);
                    for (String connectionStarName : star.connections()) {
                        Optional<FishProperties> optional = this.stars.stream().filter(fplol -> fplol.star().name().equals(connectionStarName)).findFirst();
                        if (!optional.isPresent()) continue;
                        FishProperties.Star connectionStar = optional.get().star();
                        double distance = Vector2d.distance((double)star.x(), (double)star.y(), (double)connectionStar.x(), (double)connectionStar.y());
                        int a = star.y() - connectionStar.y();
                        int b = star.x() - connectionStar.x();
                        double angle = Mth.atan2((double)a, (double)b);
                        guiGraphics.pose().pushPose();
                        guiGraphics.pose().mulPose(Axis.ZP.rotationDegrees((float)Math.toDegrees(angle) + 90.0f));
                        guiGraphics.fill(0, 0, 1, (int)distance, star.debugColor());
                        guiGraphics.pose().popPose();
                    }
                    if (Mth.abs((float)((float)x)) < 8.0f && Mth.abs((float)((float)y)) < 8.0f) {
                        guiGraphics.renderItem(new ItemStack((ItemLike)fp.catchInfo().fish().value()), 5, -7, -1);
                        guiGraphics.drawString(this.font, ((Item)fp.catchInfo().fish().value()).getDescription(), 25, -3, -1);
                    }
                    ++number;
                    guiGraphics.fill(-2, -2, 2, 2, star.debugColor());
                    pose.popPose();
                }
            }
        }
        pose.popPose();
        pose.pushPose();
        guiGraphics.fill(width / 2 - 2, height / 2 - 2, width / 2 + 2, height / 2 + 2, -65536);
        pose.popPose();
        pose.pushPose();
        pose.scale(3.0f, 3.0f, 3.0f);
        guiGraphics.drawString(this.font, "rendered " + number + " stars", 0, 0, -1);
        guiGraphics.drawString(this.font, "fps: " + this.fps, 0, 10, -1);
        pose.popPose();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.zoomScale += (float)(scrollY / 20.0);
        this.zoomScale = Math.clamp(this.zoomScale, 0.01f, 4.0f);
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    private void lockCursor() {
        this.omouseLocked = this.mouseLocked;
        if (this.mouseLocked) {
            GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)212993, (int)212994);
        } else {
            GLFW.glfwSetInputMode((long)this.minecraft.getWindow().getWindow(), (int)212993, (int)212993);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 342) {
            this.mouseLocked = false;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 342) {
            this.mouseLocked = true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (this.omouseLocked && this.mouseLocked) {
            GLFW.glfwSetCursorPos((long)this.minecraft.getWindow().getWindow(), (double)((double)this.minecraft.getWindow().getWidth() / 2.0), (double)((double)this.minecraft.getWindow().getHeight() / 2.0));
            double scale = this.zoomScale <= 1.0f ? (double)(4.0f - 3.0f * this.zoomScale) : (double)(1.0f - (this.zoomScale - 1.0f) / 4.0f);
            this.offsetX += (mouseX - (double)this.minecraft.getWindow().getGuiScaledWidth() / 2.0) * (scale /= 6.0) * (double)this.vanillaScale;
            this.offsetY += (mouseY - (double)this.minecraft.getWindow().getGuiScaledHeight() / 2.0) * scale * (double)this.vanillaScale;
            if (this.offsetX > 3600.0) {
                this.offsetX -= 3600.0;
            }
            if (this.offsetX < 0.0) {
                this.offsetX += 3600.0;
            }
            if (this.offsetY > 3600.0) {
                this.offsetY -= 3600.0;
            }
            if (this.offsetY < 0.0) {
                this.offsetY += 3600.0;
            }
        }
    }

    public void tick() {
        super.tick();
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            this.fps = this.frames;
            this.frames = 0;
        }
    }

    protected void init() {
        super.init();
        double xpos = (double)this.minecraft.getWindow().getScreenWidth() / 2.0;
        double ypos = (double)this.minecraft.getWindow().getScreenHeight() / 2.0;
        InputConstants.grabOrReleaseMouse((long)this.minecraft.getWindow().getWindow(), (int)212995, (double)xpos, (double)ypos);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

