/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks.Telescope;

import com.wdiscute.starcatcher.registry.blocks.Telescope.TelescopeScreen;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.components.IBlockPosOffsetEnum;
import org.jetbrains.annotations.Nullable;

public class TelescopeBlock
extends AbstractMultiBlock
implements IPreviewableMultiblock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<TelescopePart> TELESCOPE_PART = EnumProperty.create((String)"part", TelescopePart.class);

    public TelescopeBlock() {
        super(BlockBehaviour.Properties.of().noOcclusion());
    }

    public List<BlockPos> makeFullBlockShape(Level level, BlockPos center, BlockState blockState, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        assert (direction != null);
        return List.of(center, center.above());
    }

    public RenderShape getMultiblockRenderShape(BlockState state, boolean c) {
        return RenderShape.MODEL;
    }

    @Nullable
    public DirectionProperty getDirectionProperty() {
        return FACING;
    }

    public BlockState getStateForEachBlock(BlockState state, BlockPos pos, BlockPos centerOffset, Level level, @Nullable Direction direction) {
        state = (BlockState)state.setValue(TELESCOPE_PART, (Comparable)((Object)((TelescopePart)IBlockPosOffsetEnum.fromOffset(TelescopePart.class, (BlockPos)centerOffset, (Direction)direction, (Enum)TelescopePart.TOP))));
        return state;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{TELESCOPE_PART});
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            this.screen();
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void screen() {
        Minecraft.getInstance().setScreen((Screen)new TelescopeScreen((Component)Component.empty()));
    }

    public static enum TelescopePart implements StringRepresentable,
    IBlockPosOffsetEnum
    {
        BOTTOM("bottom", pos -> pos),
        TOP("top", BlockPos::above);

        private final String name;
        public final Function<BlockPos, BlockPos> offset;

        private TelescopePart(String name, Function<BlockPos, BlockPos> offset) {
            this.name = name;
            this.offset = offset;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Function<BlockPos, BlockPos> getOffsetFunction() {
            return this.offset;
        }
    }
}

