/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.registry.blocks;

import com.wdiscute.starcatcher.registry.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.registry.blocks.StandBlockEntity;
import com.wdiscute.starcatcher.tournament.TournamentHandler;
import com.wdiscute.starcatcher.tournament.TournamentPlayerScore;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.nikdo53.tinymultiblocklib.block.AbstractMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IMultiBlock;
import net.nikdo53.tinymultiblocklib.block.IPreviewableMultiblock;
import net.nikdo53.tinymultiblocklib.components.IBlockPosOffsetEnum;
import org.jetbrains.annotations.Nullable;

public class StandBlock
extends AbstractMultiBlock
implements IPreviewableMultiblock {
    public static final EnumProperty<StandPart> PART = EnumProperty.create((String)"stand_part", StandPart.class);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final VoxelShape SHAPE_NORTH = StandBlock.makeShapeNorth();
    private static final VoxelShape SHAPE_EAST = StandBlock.makeShapeEast();
    private static final VoxelShape SHAPE_SOUTH = StandBlock.makeShapeSouth();
    private static final VoxelShape SHAPE_WEST = StandBlock.makeShapeWest();

    public StandBlock() {
        super(BlockBehaviour.Properties.of().noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PART, (Comparable)((Object)StandPart.BOTTOM_LEFT)));
    }

    public List<BlockPos> makeFullBlockShape(Level level, BlockPos center, BlockState blockState, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        assert (direction != null);
        return List.of(center, center.above(), center.relative(direction.getCounterClockWise()), center.relative(direction.getCounterClockWise()).above());
    }

    public RenderShape getMultiblockRenderShape(BlockState state, boolean isCenter) {
        return RenderShape.MODEL;
    }

    @Nullable
    public DirectionProperty getDirectionProperty() {
        return FACING;
    }

    public BlockState getStateForEachBlock(BlockState state, BlockPos pos, BlockPos centerOffset, Level level, @Nullable Direction direction) {
        state = (BlockState)state.setValue(PART, (Comparable)((Object)((StandPart)IBlockPosOffsetEnum.fromOffset(StandPart.class, (BlockPos)centerOffset, (Direction)direction, (Enum)StandPart.BOTTOM_LEFT))));
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.getStateForPlacementHelper(context, context.getHorizontalDirection().getOpposite());
    }

    public BlockState getDefaultStateForPreviews(Direction direction) {
        return super.getDefaultStateForPreviews(direction.getOpposite());
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, (BlockPos)pos);
        BlockEntity blockEntity = level.getBlockEntity(center);
        if (blockEntity instanceof StandBlockEntity) {
            StandBlockEntity sbe = (StandBlockEntity)blockEntity;
            sbe.makeOrGetTournament();
            if (sbe.tournament.owner == null) {
                sbe.tournament.owner = player.getUUID();
                sbe.tournament.playerScores.add(TournamentPlayerScore.empty(player.getUUID()));
            }
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)sbe, (Component)Component.empty()), center);
            sbe.sync();
        }
        return InteractionResult.SUCCESS;
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockPos center = IMultiBlock.getCenter((BlockGetter)level, (BlockPos)pos);
        BlockEntity blockEntity = level.getBlockEntity(center);
        if (blockEntity instanceof StandBlockEntity) {
            StandBlockEntity sbe = (StandBlockEntity)blockEntity;
            if (!level.isClientSide && sbe.tournament != null) {
                TournamentHandler.cancelTournament(level, sbe.tournament);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public static VoxelShape makeShapeNorth() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)2.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.5, (double)0.4375, (double)2.0, (double)2.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)1.0, (double)0.4375, (double)0.0625, (double)2.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)1.9375, (double)1.0, (double)0.4375, (double)2.0, (double)2.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeEast() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.5), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)2.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)1.453125, (double)0.0, (double)0.5625, (double)1.953125, (double)2.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.953125, (double)0.0, (double)0.5625, (double)1.953125, (double)0.0625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.953125, (double)1.9375, (double)0.5625, (double)1.953125, (double)2.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeSouth() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-0.5, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.0, (double)0.875, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.0, (double)1.453125, (double)0.5, (double)1.0, (double)1.953125, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.9375, (double)0.953125, (double)0.5, (double)1.0, (double)1.953125, (double)0.5625), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)-1.0, (double)0.953125, (double)0.5, (double)-0.9375, (double)1.953125, (double)0.5625), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    public static VoxelShape makeShapeWest() {
        VoxelShape shape = Shapes.empty();
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)-0.5, (double)1.0, (double)1.0, (double)0.5), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)-1.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)1.453125, (double)-1.0, (double)0.5625, (double)1.953125, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.953125, (double)-1.0, (double)0.5625, (double)1.953125, (double)-0.9375), (BooleanOp)BooleanOp.OR);
        shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.5, (double)0.953125, (double)0.9375, (double)0.5625, (double)1.953125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = switch (this.getDirection(state).getOpposite()) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> null;
        };
        return this.voxelShapeHelper(state, level, pos, shape);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{PART});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return ModBlockEntities.STAND.get().create(blockPos, blockState);
    }

    public boolean hasCustomBE() {
        return true;
    }

    public static enum StandPart implements StringRepresentable,
    IBlockPosOffsetEnum
    {
        BOTTOM_LEFT("bottom_left", pos -> pos),
        BOTTOM_RIGHT("bottom_right", BlockPos::west),
        TOP_LEFT("top_left", BlockPos::above),
        TOP_RIGHT("top_right", pos -> pos.above().west());

        private final String name;
        public final Function<BlockPos, BlockPos> offset;

        private StandPart(String name, Function<BlockPos, BlockPos> offset) {
            this.name = name;
            this.offset = offset;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public Function<BlockPos, BlockPos> getOffsetFunction() {
            return this.offset;
        }
    }
}

