/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.registry.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipePattern;
import net.minecraft.world.level.Level;

public class ModifierShapedRecipe
implements CraftingRecipe {
    public final ShapedRecipePattern pattern;
    final ItemStack result;
    final List<ResourceLocation> minigameModifiers;
    final List<ResourceLocation> catchModifiers;
    final ResourceLocation bobberSkin;
    final String group;
    final CraftingBookCategory category;
    final boolean showNotification;

    public ModifierShapedRecipe(String group, CraftingBookCategory category, ShapedRecipePattern pattern, ItemStack result, boolean showNotification, List<ResourceLocation> minigameModifiers, List<ResourceLocation> catchModifiers, ResourceLocation bobberSkin) {
        this.group = group;
        this.category = category;
        this.pattern = pattern;
        this.result = result;
        this.showNotification = showNotification;
        this.minigameModifiers = minigameModifiers;
        this.catchModifiers = catchModifiers;
        this.bobberSkin = bobberSkin;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.MODIFIER_SHAPED_RECIPE.get();
    }

    public String getGroup() {
        return this.group;
    }

    public CraftingBookCategory category() {
        return this.category;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.pattern.ingredients();
    }

    public boolean showNotification() {
        return this.showNotification;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= this.pattern.width() && height >= this.pattern.height();
    }

    public boolean matches(CraftingInput input, Level level) {
        return this.pattern.matches(input);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack itemstack = this.getResultItem(registries).copy();
        ArrayList<ResourceLocation> catchModifiers = new ArrayList<ResourceLocation>();
        ArrayList<ResourceLocation> minigameModifiers = new ArrayList<ResourceLocation>();
        for (ResourceLocation rl : this.minigameModifiers) {
            ResourceKey catchRK = ResourceKey.create(Starcatcher.CATCH_MODIFIERS, (ResourceLocation)rl);
            ResourceKey minigameRK = ResourceKey.create(Starcatcher.MINIGAME_MODIFIERS, (ResourceLocation)rl);
            if (registries.lookupOrThrow(Starcatcher.CATCH_MODIFIERS).get(catchRK).isPresent()) {
                catchModifiers.add(rl);
            }
            if (!registries.lookupOrThrow(Starcatcher.MINIGAME_MODIFIERS).get(minigameRK).isPresent()) continue;
            minigameModifiers.add(rl);
        }
        if (!catchModifiers.isEmpty()) {
            ModDataComponents.set(itemstack, ModDataComponents.CATCH_MODIFIERS, catchModifiers);
        }
        if (!minigameModifiers.isEmpty()) {
            ModDataComponents.set(itemstack, ModDataComponents.MINIGAME_MODIFIERS, minigameModifiers);
        }
        return itemstack;
    }

    public int getWidth() {
        return this.pattern.width();
    }

    public int getHeight() {
        return this.pattern.height();
    }

    public boolean isIncomplete() {
        NonNullList<Ingredient> nonnulllist = this.getIngredients();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.isEmpty()).anyMatch(Ingredient::hasNoItems);
    }

    public static class Serializer
    implements RecipeSerializer<ModifierShapedRecipe> {
        public static final MapCodec<ModifierShapedRecipe> CODEC = RecordCodecBuilder.mapCodec(group -> group.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(shapedRecipe -> shapedRecipe.group), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(shapedRecipe -> shapedRecipe.category), (App)ShapedRecipePattern.MAP_CODEC.forGetter(shapedRecipe -> shapedRecipe.pattern), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(shapedRecipe -> shapedRecipe.result), (App)Codec.BOOL.optionalFieldOf("show_notification", (Object)Boolean.TRUE).forGetter(shapedRecipe -> shapedRecipe.showNotification), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("minigame_modifiers", List.of()).forGetter(shapedRecipe -> shapedRecipe.minigameModifiers), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("catch_modifiers", List.of()).forGetter(shapedRecipe -> shapedRecipe.catchModifiers), (App)ResourceLocation.CODEC.optionalFieldOf("bobber_skin", (Object)Starcatcher.rl("missingno")).forGetter(shapedRecipe -> shapedRecipe.bobberSkin)).apply((Applicative)group, ModifierShapedRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ModifierShapedRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ModifierShapedRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ModifierShapedRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ModifierShapedRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.readEnum(CraftingBookCategory.class);
            ShapedRecipePattern shapedrecipepattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode((Object)buffer);
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            boolean flag = buffer.readBoolean();
            List minigameModifiers = (List)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer);
            List catchModifiers = (List)ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buffer);
            ResourceLocation bobberSkin = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buffer);
            return new ModifierShapedRecipe(s, craftingbookcategory, shapedrecipepattern, itemstack, flag, minigameModifiers, catchModifiers, bobberSkin);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ModifierShapedRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            ShapedRecipePattern.STREAM_CODEC.encode((Object)buffer, (Object)recipe.pattern);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            buffer.writeBoolean(recipe.showNotification);
            ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.minigameModifiers);
            ResourceLocation.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buffer, recipe.catchModifiers);
            ResourceLocation.STREAM_CODEC.encode((Object)buffer, (Object)recipe.bobberSkin);
        }
    }
}

