/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.registry.ModRecipes;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.Level;

public record FishingRodSmithingRecipe(Ingredient template, Ingredient rod) implements SmithingRecipe
{
    public boolean matches(SmithingRecipeInput input, Level level) {
        if (input.template().is(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE) && !ModDataComponents.has(input.base(), ModDataComponents.NETHERITE_UPGRADE) && input.addition().is(Items.NETHERITE_INGOT)) {
            return true;
        }
        if (ModDataComponents.has(input.template(), ModDataComponents.TACKLE_SKIN) && input.addition().isEmpty()) {
            ResourceLocation rl = (ResourceLocation)ModDataComponents.get(input.template(), ModDataComponents.TACKLE_SKIN);
            Optional optional = level.registryAccess().registryOrThrow(Starcatcher.TACKLE_SKIN).getOptional(rl);
            return optional.isPresent();
        }
        return false;
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registries) {
        ItemStack newRod = input.base().copy();
        if (input.template().is(Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE) && input.addition().is(Items.NETHERITE_INGOT)) {
            ModDataComponents.set(newRod, ModDataComponents.NETHERITE_UPGRADE, true);
            return newRod;
        }
        if (ModDataComponents.has(input.template(), ModDataComponents.TACKLE_SKIN) && input.addition().isEmpty()) {
            ModDataComponents.set(newRod, ModDataComponents.TACKLE_SKIN, (ResourceLocation)ModDataComponents.get(input.template(), ModDataComponents.TACKLE_SKIN));
            return newRod;
        }
        throw new RuntimeException("starcatcher - that template is not supported >:( talk to @wdiscute on discord");
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public boolean isTemplateIngredient(ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean isBaseIngredient(ItemStack stack) {
        return this.rod.test(stack);
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return Arrays.stream(this.rod.getItems()).findFirst().get();
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.FISHING_ROD_SMITHING.get();
    }

    public RecipeType<?> getType() {
        return RecipeType.SMITHING;
    }

    public boolean isIncomplete() {
        return Stream.of(this.template, this.rod).anyMatch(Ingredient::hasNoItems);
    }

    public static class Serializer
    implements RecipeSerializer<FishingRodSmithingRecipe> {
        private static final MapCodec<FishingRodSmithingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(FishingRodSmithingRecipe::template), (App)Ingredient.CODEC.fieldOf("rod").forGetter(FishingRodSmithingRecipe::rod)).apply((Applicative)instance, FishingRodSmithingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FishingRodSmithingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<FishingRodSmithingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, FishingRodSmithingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static FishingRodSmithingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient template = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient rod = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            return new FishingRodSmithingRecipe(template, rod);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, FishingRodSmithingRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.rod);
        }
    }
}

