/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.minigame;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.wdiscute.starcatcher.Starcatcher;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class HitFakeParticle {
    public static final ResourceLocation TEXTURE = Starcatcher.rl("textures/gui/minigame/minigame.png");
    private static final Random random = new Random();
    public float r;
    public float g;
    public float b;
    public float a;
    public Vector2d pos;
    public double speed;
    public Vector2d vecDirection;
    public int lifetime;
    public int maxLifetime;
    public ResourceLocation rl;

    public void render(GuiGraphics guiGraphics, int width, int height) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(this.pos.x, this.pos.y, 0.0);
        RenderSystem.setShaderColor((float)this.r, (float)this.g, (float)this.b, (float)this.a);
        guiGraphics.blit(TEXTURE, width / 2 - 8, height / 2 - 8, 16, 16, 80.0f, 160.0f, 16, 16, 256, 256);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public HitFakeParticle(int x, int y, Vector2d vec) {
        this(x, y, vec, 0.5f, 0.7f + random.nextFloat() / 3.0f, 0.5f + random.nextFloat() / 5.0f, 1.0f);
    }

    public HitFakeParticle(int x, int y, Vector2d vec, float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.pos = new Vector2d((double)((float)x + random.nextFloat() * 10.0f - 5.0f), (double)((float)y + random.nextFloat() * 10.0f - 5.0f));
        this.vecDirection = vec.normalize();
        this.speed = 0.2 + (double)(random.nextFloat() / 3.0f);
        this.maxLifetime = (int)(5.0f + random.nextFloat() * 20.0f);
        if ((double)random.nextFloat() > 0.9) {
            this.maxLifetime += (int)(40.0f + random.nextFloat() * 30.0f);
        }
        this.rl = Starcatcher.rl("textures/gui/minigame.png");
    }

    public boolean tick() {
        ++this.lifetime;
        this.pos = this.pos.add((Vector2dc)new Vector2d(this.vecDirection.x * this.speed, this.vecDirection.y * this.speed));
        return this.lifetime > this.maxLifetime;
    }
}

