/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.io;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.wdiscute.starcatcher.Starcatcher;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class NBTCodecHelper {
    public static <T> void encode(Codec<T> codec, T data, CompoundTag compoundTag, String name) {
        if (data == null) {
            return;
        }
        codec.encodeStart((DynamicOps)NbtOps.INSTANCE, data).resultOrPartial(arg_0 -> ((Logger)Starcatcher.LOGGER).error(arg_0)).ifPresent(tag -> compoundTag.put(name, tag));
    }

    public static <T> T decode(Codec<T> codec, CompoundTag compoundTag, String name, Supplier<T> orElse) {
        Tag tag = compoundTag.get(name);
        return (T)codec.decode((DynamicOps)NbtOps.INSTANCE, (Object)tag).resultOrPartial(arg_0 -> ((Logger)Starcatcher.LOGGER).error(arg_0)).map(Pair::getFirst).orElseGet(orElse);
    }

    @Nullable
    public static <T> T decode(Codec<T> codec, CompoundTag compoundTag, String name) {
        if (!compoundTag.contains(name)) {
            return null;
        }
        return (T)NBTCodecHelper.decode(codec, compoundTag, name, () -> null);
    }
}

