/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.wdiscute.starcatcher.guide.FishingGuideScreen;
import com.wdiscute.starcatcher.registry.blocks.ModBlocks;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBlock;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class FishingGuideItem
extends Item {
    public FishingGuideItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos clickedPos;
        Level level = context.getLevel();
        BlockState blockState = level.getBlockState(clickedPos = context.getClickedPos());
        if (blockState.is(Blocks.LECTERN) && !((Boolean)blockState.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
            level.setBlockAndUpdate(clickedPos, (BlockState)((BlockState)((Block)ModBlocks.DISPLAY.get()).defaultBlockState().setValue((Property)DisplayBlock.HAS_BOOK, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
            BlockEntity blockEntity = level.getBlockEntity(clickedPos);
            if (blockEntity instanceof DisplayBlockEntity) {
                DisplayBlockEntity dbe = (DisplayBlockEntity)blockEntity;
                dbe.setBook(context.getItemInHand().consumeAndReturn(1, (LivingEntity)context.getPlayer()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide) {
            this.openScreen();
        }
        level.playSound(null, player.blockPosition(), SoundEvents.BOOK_PAGE_TURN, SoundSource.PLAYERS);
        return InteractionResultHolder.success((Object)player.getItemInHand(usedHand));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openScreen() {
        Minecraft.getInstance().setScreen((Screen)new FishingGuideScreen());
    }
}

