/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.guide;

import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.U;
import com.wdiscute.starcatcher.storage.FishProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public class FishCaughtToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = Starcatcher.rl("toast/fish_caught");
    private final Component title;
    private final String description;
    private static final String gibberish = "\u00a7kaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
    private int old;
    private final ItemStack is;
    private final String pre;
    private final String post;

    public FishCaughtToast(FishProperties fp) {
        this.is = new ItemStack(fp.catchInfo().fish());
        this.title = Component.translatable((String)"gui.starcatcher.toast.fish_caught");
        this.description = this.is.getHoverName().getString();
        this.pre = fp.rarity().getPre();
        this.post = fp.rarity().getPost();
    }

    public int width() {
        return 164;
    }

    public int height() {
        return 51;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        guiGraphics.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        guiGraphics.renderItem(this.is, 6, 29);
        guiGraphics.drawString(toastComponent.getMinecraft().font, this.title, 40, 13, 6508608, false);
        int lettersRevealed = Math.clamp((timeSinceLastVisible - 500L) / 150L, 0, this.description.length());
        if (this.old != lettersRevealed) {
            Minecraft.getInstance().player.playSound(SoundEvents.BAMBOO_WOOD_BUTTON_CLICK_ON, 0.4f, U.r.nextFloat(0.2f) + 1.3f);
            this.old = lettersRevealed;
        }
        MutableComponent comp = Tooltips.decodeString((String)(this.pre + this.description.substring(0, lettersRevealed) + this.post)).copy().append((Component)Component.literal((String)gibberish.substring(0, this.description.length() - lettersRevealed + 2)).withStyle(Style.EMPTY.withColor(6508608)));
        guiGraphics.drawString(toastComponent.getMinecraft().font, (Component)comp, 40, 22, 6508608, false);
        if (timeSinceLastVisible < 10000L) {
            return Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

