/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.event;

import com.mojang.brigadier.CommandDispatcher;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.commands.ModCommands;
import com.wdiscute.starcatcher.fishentity.FishEntity;
import com.wdiscute.starcatcher.io.ModDataAttachments;
import com.wdiscute.starcatcher.io.TournamentSavedData;
import com.wdiscute.starcatcher.io.attachments.FishingGuideAttachment;
import com.wdiscute.starcatcher.io.network.FPsSeenPayload;
import com.wdiscute.starcatcher.io.network.FishCaughtPayload;
import com.wdiscute.starcatcher.io.network.FishingCompletedPayload;
import com.wdiscute.starcatcher.io.network.FishingStartedPayload;
import com.wdiscute.starcatcher.io.network.tournament.CBActiveTournamentUpdatePayload;
import com.wdiscute.starcatcher.io.network.tournament.CBClearTournamentPayload;
import com.wdiscute.starcatcher.io.network.tournament.SBStandTournamentNameChangePayload;
import com.wdiscute.starcatcher.registry.ModEntities;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import com.wdiscute.starcatcher.tournament.Tournament;
import com.wdiscute.starcatcher.tournament.TournamentHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;

@EventBusSubscriber(modid="starcatcher")
public class ModEvents {
    @SubscribeEvent
    public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Tournament tournament = TournamentHandler.getTournamentForPlayer((Player)sp);
            if (tournament != null) {
                TournamentHandler.sendActiveTournamentUpdateToClient(sp, tournament);
            } else {
                TournamentHandler.clearTournamentToClient(sp);
            }
        }
    }

    @SubscribeEvent
    public static void serverStarted(ServerStartedEvent event) {
        TournamentHandler.setAll(TournamentSavedData.get(event.getServer().overworld()).getTournaments());
    }

    @SubscribeEvent
    public static void serverStopping(ServerStoppingEvent event) {
        TournamentSavedData.get(event.getServer().overworld()).setTournaments(TournamentHandler.getAll());
    }

    @SubscribeEvent
    public static void levelTick(ServerTickEvent.Post event) {
        TournamentHandler.tick(event);
    }

    @SubscribeEvent
    public static void addCommand(RegisterCommandsEvent event) {
        ModCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            FishingGuideAttachment fishingGuideAttachment = (FishingGuideAttachment)ModDataAttachments.get((Entity)serverPlayer, ModDataAttachments.FISHING_GUIDE);
            if (FishingGuideAttachment.hasLegacyData((Player)serverPlayer)) {
                fishingGuideAttachment.loadFromLegacy((Player)serverPlayer);
                FishingGuideAttachment.sync((Player)serverPlayer);
            }
            if (((Boolean)Config.GIVE_GUIDE.get()).booleanValue() && !fishingGuideAttachment.receivedGuide) {
                serverPlayer.addItem(new ItemStack((ItemLike)ModItems.GUIDE.get()));
                fishingGuideAttachment.receivedGuide = true;
            }
        }
    }

    @SubscribeEvent
    public static void addRegistry(NewRegistryEvent event) {
        event.register(Starcatcher.SWEET_SPOT_BEHAVIOUR_REGISTRY);
        event.register(Starcatcher.MINIGAME_MODIFIERS_REGISTRY);
        event.register(Starcatcher.CATCH_MODIFIERS_REGISTRY);
        event.register(Starcatcher.TACKLE_SKIN_REGISTRY);
    }

    @SubscribeEvent
    public static void addDatapackRegistry(DataPackRegistryEvent.NewRegistry event) {
        event.dataPackRegistry(Starcatcher.FISH_REGISTRY, FishProperties.CODEC, FishProperties.CODEC, builder -> builder.maxId(512));
        event.dataPackRegistry(Starcatcher.TROPHY_REGISTRY, TrophyProperties.CODEC, TrophyProperties.CODEC, builder -> builder.maxId(256));
    }

    @SubscribeEvent
    public static void dropWormsWhenBonemealing(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (event.getItemStack().is(Items.BONE_MEAL) && level.getBlockState(event.getPos()).getBlock() instanceof FarmBlock && !level.isClientSide && Config.ENABLE_BONE_MEAL_ON_FARMLAND_FOR_WORMS.getAsBoolean()) {
            float i = level.getRandom().nextFloat();
            ItemStack is = i < 0.8f ? new ItemStack((ItemLike)ModItems.WORM.get()) : (i < 0.9f ? new ItemStack((ItemLike)ModItems.ALMIGHTY_WORM.get()) : new ItemStack((ItemLike)ModItems.SEEKING_WORM.get()));
            Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)pos, (double)0.5, (double)1.01, (double)0.5).offsetRandom(level.random, 0.7f);
            ItemEntity itementity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), is);
            itementity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itementity);
            level.playSound(null, pos, SoundEvents.COMPOSTER_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                player2.swing(event.getHand(), true);
                if (!player2.hasInfiniteMaterials()) {
                    event.getItemStack().shrink(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void registerAttributed(EntityAttributeCreationEvent event) {
        event.put(ModEntities.FISH.get(), FishEntity.createAttributes().build());
    }

    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(FishingStartedPayload.TYPE, FishingStartedPayload.STREAM_CODEC, FishingStartedPayload::handle);
        registrar.playToServer(FishingCompletedPayload.TYPE, FishingCompletedPayload.STREAM_CODEC, FishingCompletedPayload::handle);
        registrar.playToClient(FishCaughtPayload.TYPE, FishCaughtPayload.STREAM_CODEC, FishCaughtPayload::handle);
        registrar.playToServer(FPsSeenPayload.TYPE, FPsSeenPayload.STREAM_CODEC, FPsSeenPayload::handle);
        registrar.playToServer(SBStandTournamentNameChangePayload.TYPE, SBStandTournamentNameChangePayload.STREAM_CODEC, SBStandTournamentNameChangePayload::handle);
        registrar.playToClient(CBActiveTournamentUpdatePayload.TYPE, CBActiveTournamentUpdatePayload.STREAM_CODEC, CBActiveTournamentUpdatePayload::handle);
        registrar.playToClient(CBClearTournamentPayload.TYPE, CBClearTournamentPayload.STREAM_CODEC, CBClearTournamentPayload::handle);
    }
}

