/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.event;

import com.wdiscute.libtooltips.Tooltips;
import com.wdiscute.starcatcher.Config;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.bob.FishingBobRenderer;
import com.wdiscute.starcatcher.fishentity.FishRenderer;
import com.wdiscute.starcatcher.fishentity.fishmodels.AgaveBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.BigeyeTuna;
import com.wdiscute.starcatcher.fishentity.fishmodels.Boreal;
import com.wdiscute.starcatcher.fishentity.fishmodels.CactiFish;
import com.wdiscute.starcatcher.fishentity.fishmodels.Charfish;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackBoreal;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackMinnow;
import com.wdiscute.starcatcher.fishentity.fishmodels.CrystalbackTrout;
import com.wdiscute.starcatcher.fishentity.fishmodels.DeepjawHerring;
import com.wdiscute.starcatcher.fishentity.fishmodels.DownfallBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.Driftfin;
import com.wdiscute.starcatcher.fishentity.fishmodels.DriftingBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.DusktailSnapper;
import com.wdiscute.starcatcher.fishentity.fishmodels.Embergill;
import com.wdiscute.starcatcher.fishentity.fishmodels.FrostgillChub;
import com.wdiscute.starcatcher.fishentity.fishmodels.FrostjawTrout;
import com.wdiscute.starcatcher.fishentity.fishmodels.HollowbellyDarter;
import com.wdiscute.starcatcher.fishentity.fishmodels.IcetoothSturgeon;
import com.wdiscute.starcatcher.fishentity.fishmodels.LilySnapper;
import com.wdiscute.starcatcher.fishentity.fishmodels.MistbackChub;
import com.wdiscute.starcatcher.fishentity.fishmodels.PinkKoi;
import com.wdiscute.starcatcher.fishentity.fishmodels.SilverveilPerch;
import com.wdiscute.starcatcher.fishentity.fishmodels.SludgeCatfish;
import com.wdiscute.starcatcher.fishentity.fishmodels.Whiteveil;
import com.wdiscute.starcatcher.fishentity.fishmodels.WillowBream;
import com.wdiscute.starcatcher.fishentity.fishmodels.WinteryPike;
import com.wdiscute.starcatcher.fishspotter.FishRadarLayer;
import com.wdiscute.starcatcher.guide.SettingsScreen;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SizeAndWeightInstance;
import com.wdiscute.starcatcher.particles.FishingBitingLavaParticles;
import com.wdiscute.starcatcher.particles.FishingBitingParticles;
import com.wdiscute.starcatcher.particles.FishingNotificationParticles;
import com.wdiscute.starcatcher.registry.ModEntities;
import com.wdiscute.starcatcher.registry.ModItemProperties;
import com.wdiscute.starcatcher.registry.ModKeymappings;
import com.wdiscute.starcatcher.registry.ModMenuTypes;
import com.wdiscute.starcatcher.registry.ModParticles;
import com.wdiscute.starcatcher.registry.blocks.ModBlockEntities;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBlockRenderer;
import com.wdiscute.starcatcher.registry.blocks.display.DisplayBookModel;
import com.wdiscute.starcatcher.registry.custom.tackleskin.BaseTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ClearTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ColorfulTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.FrogTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.KimbeTackleSkin;
import com.wdiscute.starcatcher.registry.custom.tackleskin.PearlTackleSkin;
import com.wdiscute.starcatcher.registry.items.BucketTooltipRenderer;
import com.wdiscute.starcatcher.registry.items.StarcaughtBucket;
import com.wdiscute.starcatcher.rod.FishingRodScreen;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import com.wdiscute.starcatcher.tournament.StandScreen;
import com.wdiscute.starcatcher.tournament.TournamentOverlay;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;

@EventBusSubscriber(modid="starcatcher", value={Dist.CLIENT})
public class ModClientEvents {
    @SubscribeEvent
    public static void keyPressed(InputEvent.Key event) {
        if (event.getAction() == 0 && event.getKey() == ModKeymappings.EXPAND_TOURNAMENT.getKey().getValue()) {
            TournamentOverlay.expandedType = TournamentOverlay.expandedType.next();
        }
    }

    @SubscribeEvent
    public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(ModBlockEntities.DISPLAY.get(), DisplayBlockRenderer::new);
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        TrophyProperties tp;
        List comp = event.getToolTip();
        ItemStack stack = event.getItemStack();
        if (ModDataComponents.has(stack, ModDataComponents.MINIGAME_MODIFIERS) || ModDataComponents.has(stack, ModDataComponents.CATCH_MODIFIERS)) {
            ArrayList modifiers = new ArrayList();
            if (ModDataComponents.has(stack, ModDataComponents.CATCH_MODIFIERS)) {
                modifiers.addAll(Objects.requireNonNull((List)ModDataComponents.get(stack, ModDataComponents.CATCH_MODIFIERS)));
            }
            if (ModDataComponents.has(stack, ModDataComponents.MINIGAME_MODIFIERS)) {
                modifiers.addAll(Objects.requireNonNull((List)ModDataComponents.get(stack, ModDataComponents.MINIGAME_MODIFIERS)));
            }
            if (!modifiers.isEmpty()) {
                comp.add(Component.translatable((String)"tooltip.starcatcher.modifiers").withStyle(ChatFormatting.GRAY));
                for (ResourceLocation rl : modifiers) {
                    for (int i = 0; i < 100 && I18n.exists((String)("tooltip.modifier." + rl.toLanguageKey() + "." + i)); ++i) {
                        MutableComponent start = i == 0 ? Component.literal((String)"- ") : Component.literal((String)"");
                        comp.add(start.append((Component)Component.translatable((String)("tooltip.modifier." + rl.toLanguageKey() + "." + i))).withStyle(ChatFormatting.DARK_GRAY));
                    }
                }
            }
        }
        if (ModDataComponents.has(stack, ModDataComponents.SIZE_AND_WEIGHT)) {
            SizeAndWeightInstance sw = (SizeAndWeightInstance)ModDataComponents.get(stack, ModDataComponents.SIZE_AND_WEIGHT);
            SettingsScreen.Units units = (SettingsScreen.Units)((Object)Config.UNIT.get());
            String size = units.getSizeAsString(sw.sizeInCentimeters());
            String weight = units.getWeightAsString(sw.weightInGrams());
            String percentile = " (top " + (int)sw.percentile() + "%)";
            MutableComponent element = Component.literal((String)(size + " - " + weight)).withColor(0x888888);
            if (event.getFlags().hasShiftDown()) {
                element.append((Component)Component.literal((String)percentile).withColor(0x707070));
            }
            comp.add(1, element);
        }
        if (ModDataComponents.has(stack, ModDataComponents.TACKLE_SKIN)) {
            ResourceLocation rl = (ResourceLocation)ModDataComponents.get(stack, ModDataComponents.TACKLE_SKIN);
            comp.add(Component.translatable((String)"tooltip.starcatcher.tackle").withStyle(ChatFormatting.GRAY));
            for (int i = 0; i < 100 && I18n.exists((String)("tooltip.tackle." + rl.toLanguageKey() + "." + i)); ++i) {
                MutableComponent start = i == 0 ? Component.literal((String)"- ") : Component.literal((String)"");
                comp.add(start.append((Component)Component.translatable((String)("tooltip.tackle." + rl.toLanguageKey() + "." + i))).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
        if (ModDataComponents.has(stack, ModDataComponents.NETHERITE_UPGRADE) && ((Boolean)ModDataComponents.get(stack, ModDataComponents.NETHERITE_UPGRADE)).booleanValue()) {
            comp.add(1, Tooltips.decodeTranslationKey((String)"tooltip.starcatcher.rod.netherite"));
        }
        if (ModDataComponents.has(stack, ModDataComponents.FISH_PROPERTIES)) {
            FishProperties fp = (FishProperties)ModDataComponents.get(stack, ModDataComponents.FISH_PROPERTIES);
            String s = fp.rarity().getPre() + ((Component)comp.get(0)).getString(100) + fp.rarity().getPost();
            comp.remove(0);
            comp.add(0, Tooltips.decodeString((String)s));
        }
        if (ModDataComponents.has(stack, ModDataComponents.TROPHY) && (tp = (TrophyProperties)ModDataComponents.get(stack, ModDataComponents.TROPHY)).trophyType() == TrophyProperties.TrophyType.TROPHY) {
            if (event.getFlags().hasShiftDown()) {
                comp.add(Component.translatable((String)"tooltip.libtooltips.generic.shift_down"));
                comp.add(Component.translatable((String)"tooltip.libtooltips.generic.empty"));
                comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.0"));
                comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.1"));
                ArrayList<Component> list = new ArrayList<Component>();
                if (tp.all().total() != 0) {
                    list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + tp.all().total()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.all", (Object[])new Object[0]))));
                }
                if (tp.all().unique() != 0) {
                    list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + tp.all().unique()).replace("$", I18n.get((String)"tooltip.starcatcher.trophy.all", (Object[])new Object[0]))));
                }
                for (FishProperties.Rarity value : FishProperties.Rarity.values()) {
                    TrophyProperties.RarityProgress progress = tp.getProgress(value);
                    if (progress.total() != 0) {
                        list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.total", (Object[])new Object[0]).replace("&", "" + progress.total()).replace("$", I18n.get((String)("tooltip.starcatcher.trophy." + value.getSerializedName()), (Object[])new Object[0]))));
                    }
                    if (progress.unique() == 0) continue;
                    list.add(Tooltips.decodeString((String)I18n.get((String)"tooltip.starcatcher.trophy.unique", (Object[])new Object[0]).replace("&", "" + progress.unique()).replace("$", I18n.get((String)("tooltip.starcatcher.trophy." + value.getSerializedName()), (Object[])new Object[0]))));
                }
                if (list.size() == 1) {
                    comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.once").append((Component)list.getFirst()).append((Component)Component.translatable((String)"tooltip.starcatcher.trophy.have_been_caught")));
                } else {
                    comp.add(Component.translatable((String)"tooltip.starcatcher.trophy.2"));
                    comp.addAll(list);
                }
            } else {
                comp.add(Component.translatable((String)"tooltip.libtooltips.generic.shift_up"));
            }
        }
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.register(ModEntities.FISHING_BOB.get(), FishingBobRenderer::new);
        EntityRenderers.register(ModEntities.BOTTLE.get(), ThrownItemRenderer::new);
        EntityRenderers.register(ModEntities.FISH.get(), FishRenderer::new);
        event.enqueueWork(ModItemProperties::addCustomItemProperties);
    }

    @SubscribeEvent
    public static void registerGuiLayers(RegisterGuiLayersEvent event) {
        event.registerAboveAll(Starcatcher.rl("fish_tracker"), (LayeredDraw.Layer)new FishRadarLayer());
        event.registerAboveAll(Starcatcher.rl("tournament"), (LayeredDraw.Layer)new TournamentOverlay());
    }

    @SubscribeEvent
    public static void registerParticleFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.FISHING_NOTIFICATION.get(), FishingNotificationParticles.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.FISHING_BITING.get(), FishingBitingParticles.Provider::new);
        event.registerSpriteSet((ParticleType)ModParticles.FISHING_BITING_LAVA.get(), FishingBitingLavaParticles.Provider::new);
    }

    @SubscribeEvent
    public static void registerScreens(RegisterMenuScreensEvent event) {
        event.register(ModMenuTypes.FISHING_ROD_MENU.get(), FishingRodScreen::new);
        event.register(ModMenuTypes.STAND_MENU.get(), StandScreen::new);
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(new BaseTackleSkin().getLayerLocation(), BaseTackleSkin::createBodyLayer);
        event.registerLayerDefinition(new PearlTackleSkin().getLayerLocation(), PearlTackleSkin::createBodyLayer);
        event.registerLayerDefinition(new KimbeTackleSkin().getLayerLocation(), KimbeTackleSkin::createBodyLayer);
        event.registerLayerDefinition(new FrogTackleSkin().getLayerLocation(), FrogTackleSkin::createBodyLayer);
        event.registerLayerDefinition(new ColorfulTackleSkin().getLayerLocation(), ColorfulTackleSkin::createBodyLayer);
        event.registerLayerDefinition(new ClearTackleSkin().getLayerLocation(), ClearTackleSkin::createBodyLayer);
        event.registerLayerDefinition(DisplayBookModel.LAYER_LOCATION, DisplayBookModel::createBodyLayer);
        event.registerLayerDefinition(AgaveBream.LAYER_LOCATION, AgaveBream::createBodyLayer);
        event.registerLayerDefinition(BigeyeTuna.LAYER_LOCATION, BigeyeTuna::createBodyLayer);
        event.registerLayerDefinition(Boreal.LAYER_LOCATION, Boreal::createBodyLayer);
        event.registerLayerDefinition(CactiFish.LAYER_LOCATION, CactiFish::createBodyLayer);
        event.registerLayerDefinition(Charfish.LAYER_LOCATION, Charfish::createBodyLayer);
        event.registerLayerDefinition(CrystalbackBoreal.LAYER_LOCATION, CrystalbackBoreal::createBodyLayer);
        event.registerLayerDefinition(CrystalbackMinnow.LAYER_LOCATION, CrystalbackMinnow::createBodyLayer);
        event.registerLayerDefinition(DeepjawHerring.LAYER_LOCATION, DeepjawHerring::createBodyLayer);
        event.registerLayerDefinition(DownfallBream.LAYER_LOCATION, DownfallBream::createBodyLayer);
        event.registerLayerDefinition(Driftfin.LAYER_LOCATION, Driftfin::createBodyLayer);
        event.registerLayerDefinition(DriftingBream.LAYER_LOCATION, DriftingBream::createBodyLayer);
        event.registerLayerDefinition(DusktailSnapper.LAYER_LOCATION, DusktailSnapper::createBodyLayer);
        event.registerLayerDefinition(LilySnapper.LAYER_LOCATION, LilySnapper::createBodyLayer);
        event.registerLayerDefinition(PinkKoi.LAYER_LOCATION, PinkKoi::createBodyLayer);
        event.registerLayerDefinition(SilverveilPerch.LAYER_LOCATION, SilverveilPerch::createBodyLayer);
        event.registerLayerDefinition(SludgeCatfish.LAYER_LOCATION, SludgeCatfish::createBodyLayer);
        event.registerLayerDefinition(Whiteveil.LAYER_LOCATION, Whiteveil::createBodyLayer);
        event.registerLayerDefinition(WillowBream.LAYER_LOCATION, WillowBream::createBodyLayer);
        event.registerLayerDefinition(WinteryPike.LAYER_LOCATION, WinteryPike::createBodyLayer);
        event.registerLayerDefinition(CrystalbackTrout.LAYER_LOCATION, CrystalbackTrout::createBodyLayer);
        event.registerLayerDefinition(Embergill.LAYER_LOCATION, Embergill::createBodyLayer);
        event.registerLayerDefinition(FrostgillChub.LAYER_LOCATION, FrostgillChub::createBodyLayer);
        event.registerLayerDefinition(FrostjawTrout.LAYER_LOCATION, FrostjawTrout::createBodyLayer);
        event.registerLayerDefinition(HollowbellyDarter.LAYER_LOCATION, HollowbellyDarter::createBodyLayer);
        event.registerLayerDefinition(IcetoothSturgeon.LAYER_LOCATION, IcetoothSturgeon::createBodyLayer);
        event.registerLayerDefinition(MistbackChub.LAYER_LOCATION, MistbackChub::createBodyLayer);
    }

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(ModKeymappings.MINIGAME_HIT);
        event.register(ModKeymappings.EXPAND_TOURNAMENT);
    }

    @SubscribeEvent
    public static void onRegisterTooltips(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(StarcaughtBucket.BucketTooltip.class, BucketTooltipRenderer::new);
    }
}

