/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.datagen;

import com.wdiscute.starcatcher.datagen.DGBiomeTagsProvider;
import com.wdiscute.starcatcher.datagen.DGFishingPropertiesProvider;
import com.wdiscute.starcatcher.datagen.DGModAdvancementProvider;
import com.wdiscute.starcatcher.datagen.DGModBlocksTagProvider;
import com.wdiscute.starcatcher.datagen.DGModItemModelProvider;
import com.wdiscute.starcatcher.datagen.DGModItemsTagProvider;
import com.wdiscute.starcatcher.datagen.DGTrophyPropertiesProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="starcatcher")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        PackOutput output = gen.getPackOutput();
        gen.addProvider(event.includeServer(), (DataProvider)new DGFishingPropertiesProvider(output, registries));
        gen.addProvider(event.includeServer(), (DataProvider)new DGTrophyPropertiesProvider(output, registries));
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        gen.addProvider(event.includeServer(), (DataProvider)new DGModItemModelProvider(output, existingFileHelper));
        DGModBlocksTagProvider btp = new DGModBlocksTagProvider(output, registries, existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)btp);
        DGModItemsTagProvider itp = new DGModItemsTagProvider(output, registries, btp.contentsGetter(), existingFileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)itp);
        gen.addProvider(event.includeServer(), (DataProvider)new DGModAdvancementProvider(output, registries, existingFileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new DGBiomeTagsProvider(output, registries, existingFileHelper));
    }
}

