/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.datagen;

import com.wdiscute.starcatcher.StarcatcherTags;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.fishing.DGStarcatcherFishes;
import com.wdiscute.starcatcher.storage.FishProperties;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;

public class DGModItemsTagProvider
extends ItemTagsProvider {
    public DGModItemsTagProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTags, "starcatcher", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        for (DeferredHolder item : ModItems.FISH_REGISTRY.getEntries()) {
            this.tag(ItemTags.FISHES).add((Object)((Item)item.get()));
            this.tag(ItemTags.CAT_FOOD).add((Object)((Item)item.get()));
            this.tag(Tags.Items.FOODS_RAW_FISH).add((Object)((Item)item.get()));
            this.tag(StarcatcherTags.BUCKETABLE_FISHES).add((Object)((Item)item.get()));
            this.tag(StarcatcherTags.STARCAUGHT_FISHES).add((Object)((Item)item.get()));
        }
        for (FishProperties fp : DGStarcatcherFishes.STARCATCHER_FISHES) {
            switch (fp.rarity()) {
                case COMMON: {
                    this.tag(StarcatcherTags.COMMON_FISHES).add((Object)((Item)fp.catchInfo().fish().value()));
                    break;
                }
                case UNCOMMON: {
                    this.tag(StarcatcherTags.UNCOMMON_FISHES).add((Object)((Item)fp.catchInfo().fish().value()));
                    break;
                }
                case RARE: {
                    this.tag(StarcatcherTags.RARE_FISHES).add((Object)((Item)fp.catchInfo().fish().value()));
                    break;
                }
                case EPIC: {
                    this.tag(StarcatcherTags.EPIC_FISHES).add((Object)((Item)fp.catchInfo().fish().value()));
                    break;
                }
                case LEGENDARY: {
                    this.tag(StarcatcherTags.LEGENDARY_FISHES).add((Object)((Item)fp.catchInfo().fish().value()));
                }
            }
        }
        for (DeferredHolder item : ModItems.BAITS_REGISTRY.getEntries()) {
            this.tag(StarcatcherTags.BAITS).add((Object)((Item)item.get()));
        }
        for (DeferredHolder item : ModItems.TEMPLATES_REGISTRY.getEntries()) {
            this.tag(StarcatcherTags.TEMPLATES).add((Object)((Item)item.get()));
        }
        for (DeferredHolder item : ModItems.RODS_REGISTRY.getEntries()) {
            if (item.is(ModItems.ROD)) continue;
            this.tag(StarcatcherTags.EQUIPMENTS).add((Object)((Item)item.get()));
        }
        this.tag(StarcatcherTags.HOOK_SURVIVES_LAVA).add((Object)((Item)ModItems.CRYSTAL_HOOK.get()));
        this.tag(StarcatcherTags.GADGETS).add((Object)((Item)ModItems.FISH_RADAR.get()));
        this.tag(StarcatcherTags.BAITS).add((Object)Items.BUCKET);
        this.tag(StarcatcherTags.BAITS).add((Object)Items.WITHER_SKELETON_SKULL);
        this.tag(StarcatcherTags.BAITS).addOptional(DGModItemsTagProvider.rl("fishofthieves", "earthworms"));
        this.tag(StarcatcherTags.BAITS).addOptional(DGModItemsTagProvider.rl("fishofthieves", "grubs"));
        this.tag(StarcatcherTags.BAITS).addOptional(DGModItemsTagProvider.rl("fishofthieves", "leeches"));
        this.tag(StarcatcherTags.BAITS).addOptional(DGModItemsTagProvider.rl("tfc", "food/bluegill"));
        this.tag(StarcatcherTags.BAITS).addOptional(DGModItemsTagProvider.rl("tfc", "food/cod"));
        this.tag(StarcatcherTags.BAITS).addOptional(DGModItemsTagProvider.rl("tfc", "food/salmon"));
        this.tag(StarcatcherTags.BAITS).addOptional(DGModItemsTagProvider.rl("tfc", "food/tropical_fish"));
        for (DeferredHolder item : ModItems.HOOKS_REGISTRY.getEntries()) {
            this.tag(StarcatcherTags.HOOKS).add((Object)((Item)item.get()));
        }
        this.tag(StarcatcherTags.HOOKS).addOptional(DGModItemsTagProvider.rl("tide", "void_fishing_hook"));
        for (DeferredHolder item : ModItems.BOBBERS_REGISTRY.getEntries()) {
            this.tag(StarcatcherTags.BOBBERS).add((Object)((Item)item.get()));
        }
        for (DeferredHolder item : ModItems.RODS_REGISTRY.getEntries()) {
            this.tag(Tags.Items.TOOLS_FISHING_ROD).add((Object)((Item)item.get()));
            this.tag(StarcatcherTags.RODS).add((Object)((Item)item.get()));
        }
    }

    public static ResourceLocation rl(String ns, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ns, (String)path);
    }
}

