/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.datagen;

import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.registry.fishing.FishingPropertiesRegistry;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class DGFishingPropertiesProvider
extends DatapackBuiltinEntriesProvider {
    public static final RegistrySetBuilder REGISTRY;

    public DGFishingPropertiesProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, REGISTRY, DGFishingPropertiesProvider::addConditions, Set.of("starcatcher", "minecraft", "tide", "aquaculture", "fishofthieves", "netherdepthsupgrade", "sullysmod", "upgrade_aquatic", "environmental", "collectorsreap", "miners_delight", "alexscaves", "crittersandcompanions", "aquamirae", "hybrid_aquatic", "hybrid-aquatic", "tfc", "betterend", "unusualfishmod", "spawn", "fintastic"));
    }

    private static void addConditions(BiConsumer<ResourceKey<?>, ICondition> consumer) {
        FishingPropertiesRegistry.registerConditions(consumer);
    }

    public String getName() {
        return "FishingProperties";
    }

    static {
        FishingPropertiesRegistry.register();
        REGISTRY = new RegistrySetBuilder().add(Starcatcher.FISH_REGISTRY, FishingPropertiesRegistry::bootstrap);
    }
}

