/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

public class MinigameCompletedTrigger
extends SimpleCriterionTrigger<Instance> {
    @NotNull
    public Codec<Instance> codec() {
        return Instance.CODEC;
    }

    public void trigger(ServerPlayer player, int hits, boolean perfect, boolean completedTreasure, int time, Holder<Item> caught) {
        this.trigger(player, p -> p.test(hits, perfect, completedTreasure, time, caught));
    }

    public Builder builder() {
        return new Builder();
    }

    public static class Instance
    implements SimpleCriterionTrigger.SimpleInstance {
        private static final Codec<Instance> CODEC = RecordCodecBuilder.create(i -> i.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(in -> in.player), (App)Codec.BOOL.optionalFieldOf("perfect", (Object)false).forGetter(in -> in.perfect), (App)Codec.BOOL.optionalFieldOf("treasure", (Object)false).forGetter(in -> in.completedTreasure), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.ITEM).optionalFieldOf("caught").forGetter(in -> in.caught), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("time").forGetter(in -> in.time), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("hits").forGetter(in -> in.hits)).apply((Applicative)i, Instance::new));
        private final Optional<ContextAwarePredicate> player;
        private final boolean perfect;
        private final boolean completedTreasure;
        private final Optional<HolderSet<Item>> caught;
        private final Optional<MinMaxBounds.Ints> time;
        private final Optional<MinMaxBounds.Ints> hits;

        public Instance(Optional<ContextAwarePredicate> player, boolean perfect, boolean completedTreasure, Optional<HolderSet<Item>> caught, Optional<MinMaxBounds.Ints> time, Optional<MinMaxBounds.Ints> hits) {
            this.player = player;
            this.perfect = perfect;
            this.completedTreasure = completedTreasure;
            this.caught = caught;
            this.time = time;
            this.hits = hits;
        }

        @NotNull
        public Optional<ContextAwarePredicate> player() {
            return this.player;
        }

        public boolean test(int hits, boolean perfect, boolean completedTreasure, int time, Holder<Item> caught) {
            return !this.perfect || perfect && !this.completedTreasure || completedTreasure && this.caught.map(s -> s.contains(caught)).orElse(true) != false && this.time.map(i -> i.matches(time)).orElse(true) != false && this.hits.map(i -> i.matches(hits)).orElse(true) != false;
        }
    }

    public class Builder {
        private ContextAwarePredicate player;
        private boolean perfect = false;
        private boolean treasure = false;
        private HolderSet<Item> caught;
        private MinMaxBounds.Ints time;
        private MinMaxBounds.Ints hits;

        public Builder setPlayer(ContextAwarePredicate player) {
            this.player = player;
            return this;
        }

        public Builder perfect() {
            this.perfect = true;
            return this;
        }

        public Builder treasure() {
            this.treasure = true;
            return this;
        }

        public Builder caught(HolderSet<Item> caught) {
            this.caught = caught;
            return this;
        }

        public Builder time(MinMaxBounds.Ints time) {
            this.time = time;
            return this;
        }

        public Builder hits(MinMaxBounds.Ints hits) {
            this.hits = hits;
            return this;
        }

        public Criterion<Instance> build() {
            return MinigameCompletedTrigger.this.createCriterion((CriterionTriggerInstance)new Instance(Optional.ofNullable(this.player), this.perfect, this.treasure, Optional.ofNullable(this.caught), Optional.ofNullable(this.time), Optional.ofNullable(this.hits)));
        }
    }
}

