/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher;

import com.mojang.logging.LogUtils;
import com.wdiscute.starcatcher.Starcatcher;
import com.wdiscute.starcatcher.bob.FishingBobEntity;
import com.wdiscute.starcatcher.datagen.TrustedHolder;
import com.wdiscute.starcatcher.fishentity.FishEntity;
import com.wdiscute.starcatcher.io.FishCaughtCounter;
import com.wdiscute.starcatcher.io.ModDataAttachments;
import com.wdiscute.starcatcher.io.ModDataComponents;
import com.wdiscute.starcatcher.io.SingleStackContainer;
import com.wdiscute.starcatcher.io.SizeAndWeightInstance;
import com.wdiscute.starcatcher.io.attachments.FishingBobAttachment;
import com.wdiscute.starcatcher.registry.ModCriterionTriggers;
import com.wdiscute.starcatcher.registry.ModItems;
import com.wdiscute.starcatcher.registry.custom.catchmodifiers.AbstractCatchModifier;
import com.wdiscute.starcatcher.registry.custom.tackleskin.ModTackleSkins;
import com.wdiscute.starcatcher.storage.FishProperties;
import com.wdiscute.starcatcher.storage.TrophyProperties;
import com.wdiscute.starcatcher.tournament.TournamentHandler;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.registries.DeferredItem;

public class U {
    public static final Random r = new Random();

    public static void spawnFishFromPlayerFishing(ServerPlayer player, int time, boolean completedTreasure, boolean perfectCatch, int hits) {
        ServerLevel level = (ServerLevel)player.level();
        if (((FishingBobAttachment)ModDataAttachments.get((Entity)player, ModDataAttachments.FISHING_BOB)).isEmpty()) {
            return;
        }
        Entity levelEntity = level.getEntity(((FishingBobAttachment)ModDataAttachments.get((Entity)player, ModDataAttachments.FISHING_BOB)).getUuid());
        if (levelEntity instanceof FishingBobEntity) {
            FishingBobEntity fbe = (FishingBobEntity)levelEntity;
            if (time != -1) {
                Vec3 vec3;
                FishProperties fp = fbe.fpToFish;
                ModCriterionTriggers.MINIGAME_COMPLETED.get().trigger(player, hits, perfectCatch, completedTreasure, time, fp.catchInfo().fish());
                fbe.modifiers.forEach(m -> m.onSuccessfulMinigameCompletion(player, time, completedTreasure, perfectCatch, hits));
                ModTackleSkins.get((Level)level, fbe.rod).onSuccessfulMinigame((Player)player);
                if (fbe.modifiers.stream().anyMatch(m -> m.shouldCancelAfterSuccessfulMinigameCompletion(player, time, completedTreasure, perfectCatch, hits))) {
                    return;
                }
                float percentile = r.nextFloat(100.0f);
                int size = U.getRandomSize(fp, percentile);
                int weight = U.getRandomWeight(fp, percentile);
                FishCaughtCounter.awardFishCaughtCounter(fp, (Player)player, time, size, weight, percentile, perfectCatch, true);
                TournamentHandler.addScore((Player)player, fp, perfectCatch, size, weight, percentile);
                int exp = fp.rarity().getXp();
                player.giveExperiencePoints(exp);
                if (fp.catchInfo().alwaysSpawnEntity() || ModList.get().isLoaded("fishingreal") || fbe.modifiers.stream().anyMatch(AbstractCatchModifier::forceSpawnEntity)) {
                    Vec3 objPos = player.position().subtract(fbe.position());
                    double x = objPos.x / 25.0;
                    double y = objPos.y / 20.0;
                    double z = objPos.z / 25.0;
                    x = Math.clamp(x, -1.0, 1.0);
                    y = Math.clamp(y, -1.0, 1.0);
                    z = Math.clamp(z, -1.0, 1.0);
                    x *= 2.5;
                    y *= 2.0;
                    z *= 2.5;
                    Entity entity = ((EntityType)fp.catchInfo().entityToSpawn().value()).create((Level)level);
                    if (entity == null) {
                        LogUtils.getLogger().warn("starcatcher doesnt like when the flag or whatever is not enabled");
                        return;
                    }
                    if (entity instanceof FishEntity) {
                        FishEntity fe = (FishEntity)entity;
                        fe.setFish(U.getFishedItemstackFromFP(fp, size, weight, percentile));
                    }
                    entity.setPos(fbe.position().add(0.0, (double)1.2f, 0.0));
                    vec3 = new Vec3(x, 0.7 + y, z);
                    entity.setDeltaMovement(vec3);
                    level.addFreshEntity(entity);
                } else {
                    ItemStack is;
                    boolean isBucketed;
                    ItemStack bait = ((SingleStackContainer)ModDataComponents.get(fbe.rod, ModDataComponents.BAIT)).stack().copy();
                    boolean isStarcaught = fp.catchInfo().bucketedFish().is(ModItems.STARCAUGHT_BUCKET.getKey()) && bait.is(Items.BUCKET);
                    boolean bl = isBucketed = !fp.catchInfo().bucketedFish().is(ModItems.MISSINGNO.getKey()) && !isStarcaught && bait.is(Items.BUCKET);
                    if (isBucketed) {
                        is = new ItemStack(fp.catchInfo().bucketedFish());
                    } else {
                        is = new ItemStack(fp.catchInfo().fish());
                        ModDataComponents.set(is, ModDataComponents.SIZE_AND_WEIGHT, new SizeAndWeightInstance(size, weight, percentile));
                        ModDataComponents.set(is, ModDataComponents.FISH_PROPERTIES, fp);
                        for (AbstractCatchModifier acm : fbe.modifiers) {
                            is = acm.modifyItemStack(is);
                        }
                        if (isStarcaught) {
                            ItemStack starcaughtBucket = new ItemStack(fp.catchInfo().bucketedFish());
                            ModDataComponents.set(starcaughtBucket, ModDataComponents.BUCKETED_FISH, new SingleStackContainer(is.copy()));
                            is = starcaughtBucket;
                        }
                    }
                    ItemEntity itemFished = new ItemEntity((Level)level, fbe.position().x, fbe.position().y + (double)1.2f, fbe.position().z, is);
                    double x = Math.clamp((player.position().x - fbe.position().x) / 25.0, -1.0, 1.0);
                    double y = Math.clamp((player.position().y - fbe.position().y) / 20.0, -1.0, 1.0);
                    double z = Math.clamp((player.position().z - fbe.position().z) / 25.0, -1.0, 1.0);
                    Vec3 vec32 = new Vec3(x, 0.7 + y, z);
                    itemFished.setDeltaMovement(vec32);
                    level.addFreshEntity((Entity)itemFished);
                }
                if (completedTreasure || fbe.modifiers.stream().anyMatch(m -> m.forceAwardTreasure(fbe, time, completedTreasure, perfectCatch, hits))) {
                    ItemStack treasure = new ItemStack(fp.catchInfo().treasure());
                    ItemEntity treasureFished = new ItemEntity((Level)level, fbe.position().x, fbe.position().y + (double)1.2f, fbe.position().z, treasure);
                    double x = Math.clamp((player.position().x - fbe.position().x) / 25.0, -1.0, 1.0);
                    double y = Math.clamp((player.position().y - fbe.position().y) / 20.0, -1.0, 1.0);
                    double z = Math.clamp((player.position().z - fbe.position().z) / 25.0, -1.0, 1.0);
                    vec3 = new Vec3(x, 0.7 + y, z);
                    treasureFished.setDeltaMovement(vec3);
                    level.addFreshEntity((Entity)treasureFished);
                }
            } else {
                fbe.modifiers.forEach(AbstractCatchModifier::onFailedMinigame);
                ModTackleSkins.get((Level)level, fbe.rod).onFailedMinigame((Player)player);
            }
            ItemStack bait = ((SingleStackContainer)ModDataComponents.get(fbe.rod, ModDataComponents.BAIT)).stack().copy();
            if (fbe.fpToFish.br().consumesBait()) {
                if (!bait.is(Items.BUCKET)) {
                    bait.shrink(1);
                    ModDataComponents.set(fbe.rod, ModDataComponents.BAIT, new SingleStackContainer(bait));
                }
                if (bait.is(Items.BUCKET) && !fbe.fpToFish.catchInfo().bucketedFish().is(ModItems.MISSINGNO.getKey()) && time != -1) {
                    bait.shrink(1);
                    ModDataComponents.set(fbe.rod, ModDataComponents.BAIT, new SingleStackContainer(bait));
                }
            }
            fbe.kill();
        }
        ModDataAttachments.remove((Entity)player, ModDataAttachments.FISHING_BOB.get());
    }

    public static int getRandomSize(FishProperties fp, float percentile) {
        percentile = Mth.clamp((float)percentile, (float)0.01f, (float)99.999f);
        percentile = 100.0f - percentile;
        float dev = fp.sizeWeight().sizeDeviation() * 2.0f;
        float average = fp.sizeWeight().sizeAverage();
        return (int)(average + (percentile /= 100.0f) * dev - dev / 2.0f);
    }

    public static int getRandomWeight(FishProperties fp, float percentile) {
        percentile = Mth.clamp((float)percentile, (float)0.01f, (float)99.999f);
        percentile = 100.0f - percentile;
        float dev = fp.sizeWeight().weightDeviation() * 2.0f;
        float average = fp.sizeWeight().weightAverage();
        return (int)(average + (percentile /= 100.0f) * dev - dev / 2.0f);
    }

    public static ItemStack getFishedItemstackFromFP(FishProperties fp, int size, int weight, float percentile) {
        ItemStack is = new ItemStack(fp.catchInfo().fish());
        ModDataComponents.set(is, ModDataComponents.FISH_PROPERTIES, fp);
        ModDataComponents.set(is, ModDataComponents.SIZE_AND_WEIGHT, new SizeAndWeightInstance(size, weight, percentile));
        return is;
    }

    public static List<TrophyProperties> getTpsFromRls(Registry<TrophyProperties> registry, List<ResourceLocation> resourceLocations) {
        ArrayList<TrophyProperties> tps = new ArrayList<TrophyProperties>();
        for (ResourceLocation rl : resourceLocations) {
            TrophyProperties trophyProperties = (TrophyProperties)registry.get(rl);
            if (trophyProperties == null) continue;
            tps.add(trophyProperties);
        }
        return tps;
    }

    public static List<TrophyProperties> getTpsFromRls(RegistryAccess registryAccess, List<ResourceLocation> rls) {
        return U.getTpsFromRls((Registry<TrophyProperties>)registryAccess.registryOrThrow(Starcatcher.TROPHY_REGISTRY), rls);
    }

    public static List<TrophyProperties> getTpsFromRls(Level level, List<ResourceLocation> rls) {
        return U.getTpsFromRls(level.registryAccess(), rls);
    }

    public static List<ResourceLocation> getRlsFromFps(Registry<FishProperties> registry, List<FishProperties> fishProperties) {
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (FishProperties fp : fishProperties) {
            ResourceLocation resourceLocation = registry.getKey((Object)fp);
            if (resourceLocation == null) continue;
            rls.add(resourceLocation);
        }
        return rls;
    }

    public static List<ResourceLocation> getRlsFromFps(RegistryAccess registryAccess, List<FishProperties> fps) {
        return U.getRlsFromFps((Registry<FishProperties>)registryAccess.registryOrThrow(Starcatcher.FISH_REGISTRY), fps);
    }

    public static List<ResourceLocation> getRlsFromFps(Level level, List<FishProperties> fps) {
        return U.getRlsFromFps(level.registryAccess(), fps);
    }

    public static List<ResourceLocation> getRlsFromTps(Registry<TrophyProperties> registry, List<TrophyProperties> trophyProperties) {
        ArrayList<ResourceLocation> rls = new ArrayList<ResourceLocation>();
        for (TrophyProperties tp : trophyProperties) {
            ResourceLocation resourceLocation = registry.getKey((Object)tp);
            if (resourceLocation == null) continue;
            rls.add(resourceLocation);
        }
        return rls;
    }

    public static List<ResourceLocation> getRlsFromTps(RegistryAccess registryAccess, List<TrophyProperties> tps) {
        return U.getRlsFromTps((Registry<TrophyProperties>)registryAccess.registryOrThrow(Starcatcher.TROPHY_REGISTRY), tps);
    }

    public static List<ResourceLocation> getRlsFromTps(Level level, List<TrophyProperties> tps) {
        return U.getRlsFromTps(level.registryAccess(), tps);
    }

    public static TrophyProperties getTpFromRl(Registry<TrophyProperties> registry, ResourceLocation resourceLocation) {
        TrophyProperties tp = (TrophyProperties)registry.get(resourceLocation);
        return tp == null ? TrophyProperties.builder().build() : tp;
    }

    public static TrophyProperties getTpFromRl(RegistryAccess registryAccess, ResourceLocation rl) {
        return U.getTpFromRl((Registry<TrophyProperties>)registryAccess.registryOrThrow(Starcatcher.TROPHY_REGISTRY), rl);
    }

    public static TrophyProperties getTpFromRl(Level level, ResourceLocation rl) {
        return U.getTpFromRl(level.registryAccess(), rl);
    }

    public static ResourceLocation getRlFromTp(Registry<TrophyProperties> registry, TrophyProperties tp) {
        ResourceLocation rl = registry.getKey((Object)tp);
        return rl == null ? Starcatcher.rl("missingno_rl") : rl;
    }

    public static ResourceLocation getRlFromTp(RegistryAccess registryAccess, TrophyProperties tp) {
        return U.getRlFromTp((Registry<TrophyProperties>)registryAccess.registryOrThrow(Starcatcher.TROPHY_REGISTRY), tp);
    }

    public static ResourceLocation getRlFromTp(Level level, TrophyProperties tp) {
        return U.getRlFromTp(level.registryAccess(), tp);
    }

    public static List<FishProperties> getFpsFromRls(Registry<FishProperties> registry, List<ResourceLocation> resourceLocations) {
        ArrayList<FishProperties> fps = new ArrayList<FishProperties>();
        for (ResourceLocation rl : resourceLocations) {
            FishProperties fishProperties = (FishProperties)registry.get(rl);
            if (fishProperties == null) continue;
            fps.add(fishProperties);
        }
        return fps;
    }

    public static List<FishProperties> getFpsFromRls(RegistryAccess registryAccess, List<ResourceLocation> rls) {
        return U.getFpsFromRls((Registry<FishProperties>)registryAccess.registryOrThrow(Starcatcher.FISH_REGISTRY), rls);
    }

    public static List<FishProperties> getFpsFromRls(Level level, List<ResourceLocation> rls) {
        return U.getFpsFromRls(level.registryAccess(), rls);
    }

    public static FishProperties getFpFromRl(Registry<FishProperties> registry, ResourceLocation resourceLocation) {
        FishProperties fp = (FishProperties)registry.get(resourceLocation);
        return fp == null ? FishProperties.builder().build() : fp;
    }

    public static FishProperties getFpFromRl(RegistryAccess registryAccess, ResourceLocation rl) {
        return U.getFpFromRl((Registry<FishProperties>)registryAccess.registryOrThrow(Starcatcher.FISH_REGISTRY), rl);
    }

    public static FishProperties getFpFromRl(Level level, ResourceLocation rl) {
        return U.getFpFromRl(level.registryAccess(), rl);
    }

    public static ResourceLocation getRlFromFp(Registry<FishProperties> registry, FishProperties fp) {
        ResourceLocation rl = registry.getKey((Object)fp);
        return rl == null ? Starcatcher.rl("missingno_rl") : rl;
    }

    public static ResourceLocation getRlFromFp(RegistryAccess registryAccess, FishProperties tp) {
        return U.getRlFromFp((Registry<FishProperties>)registryAccess.registryOrThrow(Starcatcher.FISH_REGISTRY), tp);
    }

    public static ResourceLocation getRlFromFp(Level level, FishProperties tp) {
        return U.getRlFromFp(level.registryAccess(), tp);
    }

    public static String calculateRealLifeTimeFromTicks(long ticks) {
        long ticksRemainingToCalculate = ticks / 20L;
        Object finalString = "";
        if (ticksRemainingToCalculate > 86400L) {
            finalString = (String)finalString + ticksRemainingToCalculate / 86400L + "d ";
            ticksRemainingToCalculate %= 86400L;
        }
        if (ticksRemainingToCalculate > 3600L) {
            finalString = (String)finalString + ticksRemainingToCalculate / 3600L + "h ";
            ticksRemainingToCalculate %= 3600L;
        }
        if (ticksRemainingToCalculate > 60L) {
            finalString = (String)finalString + ticksRemainingToCalculate / 60L + "m ";
            ticksRemainingToCalculate %= 60L;
        }
        if (ticksRemainingToCalculate > 0L) {
            finalString = (String)finalString + ticksRemainingToCalculate + "s";
        }
        return finalString;
    }

    @SafeVarargs
    public static <T> boolean containsAny(List<T> list, T ... contains) {
        for (T s : contains) {
            if (!list.contains(s)) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static <T> boolean containsAll(List<T> list, T ... contains) {
        for (T s : contains) {
            if (list.contains(s)) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> boolean containsNone(List<T> list, T ... contains) {
        return !U.containsAny(list, contains);
    }

    public static ResourceLocation rl(String ns, String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ns, (String)path);
    }

    public static Holder<Item> holderItem(String ns, String path) {
        return TrustedHolder.createStandAlone((HolderOwner)BuiltInRegistries.ITEM.holderOwner(), (ResourceKey)ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)U.rl(ns, path)));
    }

    public static Holder<Item> holderItem(DeferredItem<Item> item) {
        return Holder.direct((Object)((Item)item.get()));
    }

    public static Holder<Item> holderItem(Item item) {
        return Holder.direct((Object)item);
    }

    public static Holder<EntityType<?>> holderEntity(EntityType<?> entityType) {
        return Holder.direct(entityType);
    }

    public static Holder<EntityType<?>> holderEntity(String ns, String path) {
        return TrustedHolder.createStandAlone((HolderOwner)BuiltInRegistries.ENTITY_TYPE.holderOwner(), (ResourceKey)ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)U.rl(ns, path)));
    }

    public static Holder<EntityType<?>> holderEntity(Supplier<EntityType<FishEntity>> entity) {
        return Holder.direct(entity.get());
    }

    public static int intToRed(int packedColor) {
        return packedColor >> 16 & 0xFF;
    }

    public static int intToGreen(int packedColor) {
        return packedColor >> 8 & 0xFF;
    }

    public static int intToBlue(int packedColor) {
        return packedColor & 0xFF;
    }

    public static int sign(float x) {
        return x >= 0.0f ? 1 : -1;
    }

    public static long getTime() {
        return Instant.now().getEpochSecond();
    }
}

