/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item;

import com.google.common.collect.Lists;
import it.hurts.octostudios.reliquified_twilight_forest.init.DataComponentRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface BundleLike {
    default public int getMaxSlots(ItemStack stack) {
        return 1;
    }

    default public int getMaxSlotStackSize(ItemStack stack) {
        return 1;
    }

    default public boolean tryInsert(Player player, ItemStack bundleStack, ItemStack toInsert) {
        List notMutable = (List)bundleStack.get(DataComponentRegistry.BUNDLE_LIKE_CONTENTS);
        if (notMutable == null) {
            return false;
        }
        ArrayList contents = Lists.newArrayList((Iterable)notMutable);
        int maxSlots = this.getMaxSlots(bundleStack);
        int maxStackSize = this.getMaxSlotStackSize(bundleStack);
        for (ItemStack contained : contents) {
            int currentCount;
            if (contained.isEmpty() || contained.getItem() != toInsert.getItem() || (currentCount = contained.getCount()) >= maxStackSize) continue;
            int freeSpace = maxStackSize - currentCount;
            int inserting = Math.min(freeSpace, toInsert.getCount());
            contained.grow(inserting);
            toInsert.shrink(inserting);
            this.setContents(player, bundleStack, contents);
            return true;
        }
        if (contents.size() < maxSlots) {
            int inserting = Math.min(maxStackSize, toInsert.getCount());
            ItemStack newStack = toInsert.copy();
            newStack.setCount(inserting);
            toInsert.shrink(inserting);
            contents.add(newStack);
            this.setContents(player, bundleStack, contents);
            return true;
        }
        return false;
    }

    default public ItemStack pop(Player player, ItemStack stack) {
        List<ItemStack> notMutable = this.getContents(stack);
        if (notMutable.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ArrayList contents = Lists.newArrayList(notMutable);
        ItemStack toReturn = (ItemStack)contents.remove(contents.size() - 1);
        contents.removeIf(ItemStack::isEmpty);
        this.setContents(player, stack, contents);
        return toReturn;
    }

    default public void dropExcessive(Player player, ItemStack stack) {
        List<ItemStack> notMutable = this.getContents(stack);
        ArrayList contents = Lists.newArrayList(notMutable);
        int maxStacks = this.getMaxSlots(stack);
        int maxStackSize = this.getMaxSlotStackSize(stack);
        if (contents.size() > maxStacks) {
            List toDrop = contents.subList(maxStacks - 1, contents.size() - 1);
            for (ItemStack drop : toDrop) {
                ItemEntity entity = player.drop(drop, false, true);
                if (entity == null) continue;
                entity.setNoPickUpDelay();
            }
            toDrop.clear();
        }
        contents.removeIf(ItemStack::isEmpty);
        int maxStackSizeFound = contents.stream().mapToInt(ItemStack::getCount).max().orElse(0);
        if (maxStackSizeFound > maxStackSize) {
            contents = Lists.newArrayList(contents.stream().map(itemStack -> {
                if (itemStack.getCount() < maxStackSize) {
                    return itemStack;
                }
                int excess = itemStack.getCount() - maxStackSize;
                ItemEntity entity = player.drop(itemStack.copyWithCount(excess), false, true);
                if (entity != null) {
                    entity.setNoPickUpDelay();
                }
                itemStack.shrink(excess);
                return itemStack;
            }).toList());
        }
        contents.removeIf(ItemStack::isEmpty);
        this.setContents(player, stack, contents);
    }

    default public void dropAll(Player player, ItemStack stack) {
        List<ItemStack> notMutable = this.getContents(stack);
        ArrayList contents = Lists.newArrayList(notMutable);
        for (ItemStack drop : contents) {
            ItemEntity entity = player.drop(drop, false, true);
            if (entity == null) continue;
            entity.setNoPickUpDelay();
        }
        contents.clear();
        this.setContents(player, stack, contents);
    }

    @NotNull
    default public List<ItemStack> getContents(ItemStack stack) {
        return (List)stack.getOrDefault(DataComponentRegistry.BUNDLE_LIKE_CONTENTS, List.of());
    }

    default public void setContents(Player player, ItemStack stack, List<ItemStack> contents) {
        List<ItemStack> oldContents = this.getContents(stack);
        if (oldContents.equals(contents)) {
            return;
        }
        stack.set(DataComponentRegistry.BUNDLE_LIKE_CONTENTS, contents.stream().filter(itemStack -> !itemStack.isEmpty()).toList());
        this.onContentsChanged(player, stack, oldContents);
    }

    default public int getItemCount(ItemStack stack, Item item) {
        return this.getItemCount(stack, item, this.getContents(stack));
    }

    default public int getItemCount(ItemStack stack, Item item, List<ItemStack> contents) {
        return (int)contents.stream().filter(itemStack -> itemStack.getItem() == item).count();
    }

    default public int getTotalItemCount(ItemStack stack, Item item) {
        return this.getTotalItemCount(stack, item, this.getContents(stack));
    }

    default public int getTotalItemCount(ItemStack stack, Item item, List<ItemStack> contents) {
        return contents.stream().filter(itemStack -> itemStack.getItem() == item).mapToInt(ItemStack::getCount).sum();
    }

    default public void onContentsChanged(Player player, ItemStack stack, List<ItemStack> oldContents) {
    }

    default public void playInsertSound(Player player, ItemStack toInsert) {
        player.playSound(SoundEvents.AMETHYST_BLOCK_STEP, 1.0f, 1.25f);
    }

    default public void playPopSound(Player player, ItemStack toPop) {
        player.playSound(SoundEvents.ITEM_PICKUP, 0.75f, 1.25f);
    }

    default public Predicate<ItemStack> getPredicate() {
        return stack -> true;
    }

    default public boolean isAcceptable(ItemStack stack) {
        return this.getPredicate().test(stack);
    }
}

