/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.villagerpack;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.registry.VAPIMapDecorations;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;

public class VillagerPackCodecs {
    private static HolderLookup.Provider registryLookup = null;

    public static void setRegistryLookup(HolderLookup.Provider lookup) {
        registryLookup = lookup;
    }

    public static ProfessionData parseProfession(JsonObject json) {
        String poiType = json.get("poi_type").getAsString();
        String workSound = json.get("work_sound").getAsString();
        String namespace = json.get("namespace").getAsString();
        return new ProfessionData(poiType, ResourceLocation.parse((String)workSound), namespace);
    }

    public static PoiTypeData parsePoiType(JsonObject json) {
        String block = json.get("block").getAsString();
        int tickets = json.has("tickets") ? json.get("tickets").getAsInt() : 1;
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new PoiTypeData(ResourceLocation.parse((String)block), tickets, namespace);
    }

    public static VillagerTypeData parseVillagerType(JsonObject json) {
        String name = json.get("name").getAsString();
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new VillagerTypeData(name, namespace);
    }

    public static StructureTagData parseStructureTag(JsonObject json) {
        String name = json.get("tag").getAsString();
        String decoration = json.get("map_decoration").getAsString();
        String map_color = json.get("map_color").getAsString();
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new StructureTagData(name, decoration, map_color, namespace);
    }

    public static WorkstationData parseWorkstation(JsonObject json) {
        String name = json.get("name").getAsString();
        String namespace = json.has("namespace") ? json.get("namespace").getAsString() : "villagerapi";
        return new WorkstationData(name, namespace);
    }

    public static GiftData parseGift(JsonObject json) {
        String profession = json.get("profession").getAsString();
        String lootTable = json.get("loot_table").getAsString();
        return new GiftData(profession, ResourceLocation.parse((String)lootTable));
    }

    public static TradesData parseTrades(JsonObject json) {
        String profession = json.get("profession").getAsString();
        JsonObject levelsObj = json.getAsJsonObject("levels");
        Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
        for (String levelStr : levelsObj.keySet()) {
            int level = Integer.parseInt(levelStr);
            JsonArray tradesArray = levelsObj.getAsJsonArray(levelStr);
            ArrayList<VillagerTrades.ItemListing> listings = new ArrayList<VillagerTrades.ItemListing>();
            for (JsonElement tradeElement : tradesArray) {
                JsonObject tradeObj = tradeElement.getAsJsonObject();
                VillagerTrades.ItemListing listing = VillagerPackCodecs.parseTrade(tradeObj);
                if (listing == null) continue;
                listings.add(listing);
            }
            trades.put(level, (Object)listings.toArray(new VillagerTrades.ItemListing[0]));
        }
        return new TradesData(profession, (Int2ObjectMap<VillagerTrades.ItemListing[]>)trades);
    }

    public static BiomeTradesData parseBiomeTrades(JsonObject json) {
        String profession = json.get("profession").getAsString();
        JsonObject biomeOverrides = json.getAsJsonObject("biome_overrides");
        HashMap<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>> biomeTradeMap = new HashMap<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>>();
        HashMap<VillagerType, Map<Integer, Boolean>> replaceFlags = new HashMap<VillagerType, Map<Integer, Boolean>>();
        for (String biomeTypeKey : biomeOverrides.keySet()) {
            VillagerType villagerType = (VillagerType)BuiltInRegistries.VILLAGER_TYPE.get(ResourceLocation.parse((String)biomeTypeKey));
            if (villagerType == null) {
                VillagerAPI.LOGGER.warn("Unknown villager type: {}", (Object)biomeTypeKey);
                continue;
            }
            JsonObject biomeData = biomeOverrides.getAsJsonObject(biomeTypeKey);
            JsonObject levelsObj = biomeData.getAsJsonObject("levels");
            Int2ObjectOpenHashMap trades = new Int2ObjectOpenHashMap();
            HashMap<Integer, Boolean> levelReplaceFlags = new HashMap<Integer, Boolean>();
            for (String levelStr : levelsObj.keySet()) {
                JsonArray tradesArray;
                int level = Integer.parseInt(levelStr);
                JsonElement levelElement = levelsObj.get(levelStr);
                boolean replace = false;
                if (levelElement.isJsonArray()) {
                    tradesArray = levelElement.getAsJsonArray();
                } else if (levelElement.isJsonObject()) {
                    JsonObject levelObj = levelElement.getAsJsonObject();
                    replace = levelObj.has("replace") && levelObj.get("replace").getAsBoolean();
                    tradesArray = levelObj.getAsJsonArray("trades");
                } else {
                    VillagerAPI.LOGGER.warn("Invalid level data format for level {} in biome {}", (Object)levelStr, (Object)biomeTypeKey);
                    continue;
                }
                ArrayList<VillagerTrades.ItemListing> listings = new ArrayList<VillagerTrades.ItemListing>();
                for (JsonElement tradeElement : tradesArray) {
                    JsonObject tradeObj = tradeElement.getAsJsonObject();
                    VillagerTrades.ItemListing listing = VillagerPackCodecs.parseTrade(tradeObj);
                    if (listing == null) continue;
                    listings.add(listing);
                }
                trades.put(level, (Object)listings.toArray(new VillagerTrades.ItemListing[0]));
                levelReplaceFlags.put(level, replace);
            }
            biomeTradeMap.put(villagerType, (Int2ObjectMap<VillagerTrades.ItemListing[]>)trades);
            replaceFlags.put(villagerType, levelReplaceFlags);
        }
        return new BiomeTradesData(profession, biomeTradeMap, replaceFlags);
    }

    private static VillagerTrades.ItemListing parseTrade(JsonObject json) {
        try {
            JsonElement sellElement = json.get("sell");
            if (sellElement != null && sellElement.isJsonObject()) {
                String itemType;
                JsonObject sellObj = sellElement.getAsJsonObject();
                String string = itemType = sellObj.has("item_type") ? sellObj.get("item_type").getAsString() : "simple";
                if ("treasure_map".equals(itemType)) {
                    return VillagerPackCodecs.parseTreasureMapTrade(json, sellObj);
                }
            }
            return VillagerPackCodecs.parseSimpleTrade(json);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to parse trade: {}", (Object)json, (Object)e);
            return null;
        }
    }

    private static VillagerTrades.ItemListing parseSimpleTrade(JsonObject json) {
        LazyItemStack buyA = VillagerPackCodecs.parseLazyItemStack(json.get("buy_a"));
        LazyItemStack buyB = json.has("buy_b") ? VillagerPackCodecs.parseLazyItemStack(json.get("buy_b")) : null;
        LazyItemStack sell = VillagerPackCodecs.parseLazyItemStack(json.get("sell"));
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 16;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 1;
        float priceMultiplier = json.has("price_multiplier") ? json.get("price_multiplier").getAsFloat() : 0.05f;
        return (trader, random) -> {
            ItemStack buyAStack = buyA.resolve();
            ItemStack buyBStack = buyB != null ? buyB.resolve() : ItemStack.EMPTY;
            ItemStack sellStack = sell.resolve();
            if (buyAStack.isEmpty() || sellStack.isEmpty()) {
                return null;
            }
            ItemCost costA = new ItemCost(buyAStack.getItemHolder(), buyAStack.getCount(), DataComponentPredicate.allOf((DataComponentMap)buyAStack.getComponents()));
            Optional costB = buyBStack.isEmpty() ? Optional.empty() : Optional.of(new ItemCost(buyBStack.getItemHolder(), buyBStack.getCount(), DataComponentPredicate.allOf((DataComponentMap)buyBStack.getComponents())));
            return new MerchantOffer(costA, costB, sellStack.copy(), maxUses, xp, priceMultiplier);
        };
    }

    private static VillagerTrades.ItemListing parseTreasureMapTrade(JsonObject json, JsonObject sellObj) {
        LazyItemStack buyA = VillagerPackCodecs.parseLazyItemStack(json.get("buy_a"));
        LazyItemStack buyB = json.has("buy_b") ? VillagerPackCodecs.parseLazyItemStack(json.get("buy_b")) : null;
        String structureTag = sellObj.get("structure_tag").getAsString();
        String displayName = sellObj.get("display_name").getAsString();
        String mapDecorationInput = sellObj.get("map_decoration").getAsString();
        int maxUses = json.has("max_uses") ? json.get("max_uses").getAsInt() : 12;
        int xp = json.has("xp") ? json.get("xp").getAsInt() : 5;
        TagKey tag = TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.parse((String)structureTag));
        VillagerAPI.LOGGER.info("Structure tag created: {}", (Object)tag.location());
        ResourceLocation mapDecorationLoc = ResourceLocation.parse((String)mapDecorationInput);
        VillagerAPI.LOGGER.info("Looking for map decoration: {}", (Object)mapDecorationInput);
        return (trader, random) -> {
            ItemStack buyBStack;
            ItemStack buyAStack = buyA.resolve();
            ItemStack itemStack = buyBStack = buyB != null ? buyB.resolve() : ItemStack.EMPTY;
            if (buyAStack.isEmpty()) {
                VillagerAPI.LOGGER.warn("Trade has empty buy_a stack, skipping");
                return null;
            }
            Supplier<MapDecorationType> dynamicDecoration = VAPIMapDecorations.getDynamicMapDecorationType(mapDecorationInput);
            Holder decoration = null;
            if (dynamicDecoration != null) {
                MapDecorationType decorationType = dynamicDecoration.get();
                decoration = BuiltInRegistries.MAP_DECORATION_TYPE.wrapAsHolder((Object)decorationType);
                VillagerAPI.LOGGER.info("Found dynamic map decoration: {}", (Object)mapDecorationInput);
            } else {
                ResourceKey decorationKey = ResourceKey.create((ResourceKey)Registries.MAP_DECORATION_TYPE, (ResourceLocation)mapDecorationLoc);
                decoration = BuiltInRegistries.MAP_DECORATION_TYPE.getHolder(decorationKey).orElse(null);
                if (decoration != null) {
                    VillagerAPI.LOGGER.info("Found vanilla/mod map decoration: {}", (Object)mapDecorationLoc);
                }
            }
            if (decoration == null) {
                VillagerAPI.LOGGER.error("Map decoration not found: {}", (Object)mapDecorationInput);
                VillagerAPI.LOGGER.error("Available dynamic decorations: {}", VAPIMapDecorations.getDynamicMapDecorationTypes().keySet());
                return null;
            }
            if (buyAStack.is(Items.EMERALD) && buyBStack.isEmpty()) {
                int emeraldCost = buyAStack.getCount();
                VillagerTrades.TreasureMapForEmeralds mapTrade = new VillagerTrades.TreasureMapForEmeralds(emeraldCost, tag, displayName, decoration, maxUses, xp);
                MerchantOffer offer = mapTrade.getOffer(trader, random);
                if (offer == null) {
                    VillagerAPI.LOGGER.error("Failed to create treasure map offer for tag: {} with decoration: {}. This usually means no structures matching the tag were found nearby, or the structure tag doesn't exist.", (Object)structureTag, (Object)mapDecorationInput);
                }
                return offer;
            }
            VillagerTrades.TreasureMapForEmeralds mapTrade = new VillagerTrades.TreasureMapForEmeralds(1, tag, displayName, decoration, maxUses, xp);
            MerchantOffer mapOffer = mapTrade.getOffer(trader, random);
            if (mapOffer == null) {
                VillagerAPI.LOGGER.error("Failed to create treasure map offer for tag: {} with decoration: {}. This usually means no structures matching the tag were found nearby, or the structure tag doesn't exist.", (Object)structureTag, (Object)mapDecorationInput);
                return null;
            }
            ItemCost costA = new ItemCost(buyAStack.getItemHolder(), buyAStack.getCount(), DataComponentPredicate.allOf((DataComponentMap)buyAStack.getComponents()));
            Optional costB = buyBStack.isEmpty() ? Optional.empty() : Optional.of(new ItemCost(buyBStack.getItemHolder(), buyBStack.getCount(), DataComponentPredicate.allOf((DataComponentMap)buyBStack.getComponents())));
            return new MerchantOffer(costA, costB, mapOffer.getResult(), maxUses, xp, 0.05f);
        };
    }

    private static LazyItemStack parseLazyItemStack(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return new LazyItemStack(element.getAsString(), 1, null);
        }
        JsonObject obj = element.getAsJsonObject();
        String itemId = obj.get("item").getAsString();
        int count = obj.has("count") ? obj.get("count").getAsInt() : 1;
        JsonObject components = obj.has("components") ? obj.getAsJsonObject("components") : null;
        return new LazyItemStack(itemId, count, components);
    }

    private static ItemStack parseItemStack(JsonElement element) {
        return VillagerPackCodecs.parseLazyItemStack(element).resolve();
    }

    private static void applyComponentData(ItemStack stack, JsonObject componentsObj) {
        if (registryLookup == null) {
            VillagerAPI.LOGGER.error("Registry lookup not available for component parsing");
            return;
        }
        try {
            CompoundTag componentsTag = new CompoundTag();
            for (String key : componentsObj.keySet()) {
                JsonElement value = componentsObj.get(key);
                if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isNumber()) {
                    componentsTag.putInt(key, value.getAsInt());
                    continue;
                }
                if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
                    componentsTag.putString(key, value.getAsString());
                    continue;
                }
                if (value.isJsonObject()) {
                    componentsTag.put(key, (Tag)VillagerPackCodecs.jsonObjectToNbt(value.getAsJsonObject()));
                    continue;
                }
                String valueStr = value.toString();
                try {
                    CompoundTag parsedValue = CompoundTagArgument.compoundTag().parse(new StringReader(valueStr));
                    componentsTag.put(key, (Tag)parsedValue);
                }
                catch (CommandSyntaxException e) {
                    VillagerAPI.LOGGER.error("Failed to parse component value for '{}': {}", new Object[]{key, valueStr, e});
                }
            }
            RegistryOps registryOps = registryLookup.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            DataComponentPatch patch = DataComponentPatch.CODEC.parse((DynamicOps)registryOps, (Object)componentsTag).resultOrPartial(error -> VillagerAPI.LOGGER.error("Failed to parse components: {}", error)).orElse(DataComponentPatch.EMPTY);
            stack.applyComponents(patch);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to apply component data: {}", (Object)componentsObj, (Object)e);
        }
    }

    private static CompoundTag jsonObjectToNbt(JsonObject json) {
        CompoundTag tag = new CompoundTag();
        for (String key : json.keySet()) {
            JsonElement value = json.get(key);
            tag.put(key, VillagerPackCodecs.jsonElementToNbt(value));
        }
        return tag;
    }

    private static Tag jsonElementToNbt(JsonElement element) {
        if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            if (primitive.isNumber()) {
                return IntTag.valueOf((int)primitive.getAsInt());
            }
            if (primitive.isString()) {
                return StringTag.valueOf((String)primitive.getAsString());
            }
            if (primitive.isBoolean()) {
                return ByteTag.valueOf((boolean)primitive.getAsBoolean());
            }
        } else {
            if (element.isJsonObject()) {
                return VillagerPackCodecs.jsonObjectToNbt(element.getAsJsonObject());
            }
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                ListTag list = new ListTag();
                for (JsonElement item : array) {
                    list.add((Object)VillagerPackCodecs.jsonElementToNbt(item));
                }
                return list;
            }
        }
        return StringTag.valueOf((String)element.toString());
    }

    public record ProfessionData(String poiType, ResourceLocation workSound, String namespace) {
    }

    public record PoiTypeData(ResourceLocation block, int tickets, String namespace) {
    }

    public record VillagerTypeData(String name, String namespace) {
    }

    public record StructureTagData(String name, String decoration, String map_color, String namespace) {
    }

    public record WorkstationData(String name, String namespace) {
    }

    public record GiftData(String profession, ResourceLocation lootTable) {
    }

    public record TradesData(String profession, Int2ObjectMap<VillagerTrades.ItemListing[]> trades) {
    }

    public record BiomeTradesData(String profession, Map<VillagerType, Int2ObjectMap<VillagerTrades.ItemListing[]>> biomeTradeMap, Map<VillagerType, Map<Integer, Boolean>> replaceFlags) {
    }

    private static class LazyItemStack {
        private final String itemId;
        private final int count;
        private final JsonObject components;
        private ItemStack cached;

        public LazyItemStack(String itemId, int count, JsonObject components) {
            this.itemId = itemId;
            this.count = count;
            this.components = components;
        }

        public ItemStack resolve() {
            if (this.cached != null) {
                return this.cached;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)this.itemId));
            if (item == null || item == Items.AIR) {
                VillagerAPI.LOGGER.warn("Item {} not found, using AIR", (Object)this.itemId);
                this.cached = ItemStack.EMPTY;
                return this.cached;
            }
            this.cached = new ItemStack((ItemLike)item, this.count);
            if (this.components != null) {
                VillagerPackCodecs.applyComponentData(this.cached, this.components);
            }
            return this.cached;
        }
    }
}

