/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.registry.VAPIPoiTypes;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;

public class VAPIProfessions {
    private static final Map<String, Supplier<VillagerProfession>> DYNAMIC_PROFESSIONS = new HashMap<String, Supplier<VillagerProfession>>();
    private static final Map<String, ProfessionInfo> PROFESSION_DATA = new HashMap<String, ProfessionInfo>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.ProfessionData profData = VillagerPackCodecs.parseProfession(json);
            String registryName = name.replace("/", "_");
            String namespace = profData.namespace() != null ? profData.namespace() : "villagerapi";
            PROFESSION_DATA.put(name, new ProfessionInfo(registryName, namespace, profData.poiType(), profData.workSound()));
            Supplier<VillagerProfession> profession = CommonPlatformHelper.registerProfession(namespace, registryName, () -> {
                Supplier<PoiType> poiTypeSupplier = VAPIPoiTypes.getDynamicPoiType(profData.poiType());
                if (poiTypeSupplier == null) {
                    VillagerAPI.LOGGER.warn("POI type {} not found for profession {}. Profession will not function.", (Object)profData.poiType(), (Object)registryName);
                    return new VillagerProfession(registryName, holder -> false, holder -> false, ImmutableSet.of(), ImmutableSet.of(), SoundEvents.VILLAGER_WORK_ARMORER);
                }
                SoundEvent workSound = (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(profData.workSound());
                if (workSound == null) {
                    VillagerAPI.LOGGER.warn("Sound event {} not found for profession {}, using default", (Object)profData.workSound(), (Object)registryName);
                    workSound = SoundEvents.VILLAGER_WORK_ARMORER;
                }
                return new VillagerProfession(registryName, holder -> ((PoiType)holder.value()).equals(poiTypeSupplier.get()), holder -> ((PoiType)holder.value()).equals(poiTypeSupplier.get()), ImmutableSet.of(), ImmutableSet.of(), workSound);
            });
            DYNAMIC_PROFESSIONS.put(name, profession);
            VillagerAPI.LOGGER.info("Registered profession from pack: {}", (Object)name);
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register profession from pack: {}", (Object)name, (Object)e);
        }
    }

    public static void validateProfessions() {
        int valid = 0;
        int invalid = 0;
        for (Map.Entry<String, ProfessionInfo> entry : PROFESSION_DATA.entrySet()) {
            String name = entry.getKey();
            ProfessionInfo data = entry.getValue();
            Supplier<PoiType> poiType = VAPIPoiTypes.getDynamicPoiType(data.poiTypeName);
            if (poiType == null) {
                ++invalid;
                VillagerAPI.LOGGER.warn("Profession '{}' references missing POI type '{}' - will not function", (Object)name, (Object)data.poiTypeName);
                continue;
            }
            ++valid;
            VillagerAPI.LOGGER.debug("Profession '{}' validated with POI type '{}'", (Object)name, (Object)data.poiTypeName);
        }
        if (valid > 0 || invalid > 0) {
            VillagerAPI.LOGGER.info("Profession validation: {} valid, {} invalid", (Object)valid, (Object)invalid);
        }
    }

    public static Supplier<VillagerProfession> getDynamicProfession(String name) {
        return DYNAMIC_PROFESSIONS.get(name);
    }

    public static Map<String, Supplier<VillagerProfession>> getDynamicProfessions() {
        return new HashMap<String, Supplier<VillagerProfession>>(DYNAMIC_PROFESSIONS);
    }

    private static class ProfessionInfo {
        final String registryName;
        final String namespace;
        final String poiTypeName;
        final ResourceLocation workSoundId;

        ProfessionInfo(String registryName, String namespace, String poiTypeName, ResourceLocation workSoundId) {
            this.registryName = registryName;
            this.namespace = namespace;
            this.poiTypeName = poiTypeName;
            this.workSoundId = workSoundId;
        }
    }
}

