/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.registry;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.platform.CommonPlatformHelper;
import com.frikinjay.villagerapi.villagerpack.VillagerPackCodecs;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;

public class VAPIMapDecorations {
    private static final Map<String, Supplier<MapDecorationType>> DYNAMIC_MAP_DECORATIONS = new HashMap<String, Supplier<MapDecorationType>>();

    public static void init() {
    }

    public static void registerFromPack(String name, JsonObject json) {
        try {
            VillagerPackCodecs.StructureTagData decorationData = VillagerPackCodecs.parseStructureTag(json);
            String decorationName = decorationData.decoration();
            String registryName = decorationName.replace("/", "_");
            String namespace = decorationData.namespace() != null ? decorationData.namespace() : "villagerapi";
            int map_color = VAPIMapDecorations.hexToInt(decorationData.map_color());
            ResourceLocation decorationId = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)decorationName);
            Supplier<MapDecorationType> type = CommonPlatformHelper.registerMapDecorationType(namespace, registryName, () -> new MapDecorationType(decorationId, true, map_color, false, true));
            String fullKey = namespace + ":" + registryName;
            DYNAMIC_MAP_DECORATIONS.put(fullKey, type);
            DYNAMIC_MAP_DECORATIONS.put(registryName, type);
            VillagerAPI.LOGGER.info("Registered map decoration type from pack: {} -> {} (keys: {}, {})", new Object[]{decorationName, registryName, fullKey, registryName});
        }
        catch (Exception e) {
            VillagerAPI.LOGGER.error("Failed to register map decoration type from structure tag json of pack: {}", (Object)name, (Object)e);
        }
    }

    public static Supplier<MapDecorationType> getDynamicMapDecorationType(String name) {
        String namespacedKey;
        Supplier<MapDecorationType> result = DYNAMIC_MAP_DECORATIONS.get(name);
        if (result != null) {
            return result;
        }
        String convertedName = name.replace("/", "_");
        result = DYNAMIC_MAP_DECORATIONS.get(convertedName);
        if (result != null) {
            return result;
        }
        if (!name.contains(":") && (result = DYNAMIC_MAP_DECORATIONS.get(namespacedKey = "villagerapi:" + convertedName)) != null) {
            return result;
        }
        return null;
    }

    public static Map<String, Supplier<MapDecorationType>> getDynamicMapDecorationTypes() {
        return new HashMap<String, Supplier<MapDecorationType>>(DYNAMIC_MAP_DECORATIONS);
    }

    public static int hexToInt(String hexColor) {
        if (hexColor.startsWith("#")) {
            hexColor = hexColor.substring(1);
        }
        return Integer.parseInt(hexColor, 16);
    }
}

