/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.neoforge;

import com.frikinjay.villagerapi.VillagerAPI;
import com.frikinjay.villagerapi.registry.VAPICreativeTabs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(modid="villagerapi", bus=EventBusSubscriber.Bus.MOD)
public class VillagerPackCreativeTabsNeoForge {
    @SubscribeEvent
    public static void registerCreativeTabs(RegisterEvent event) {
        event.register(Registries.CREATIVE_MODE_TAB, helper -> VAPICreativeTabs.getAllTabs().forEach((namespace, tabData) -> {
            try {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (Supplier<Block> workstation : tabData.getWorkstations()) {
                    Block block = workstation.get();
                    if (block == null) continue;
                    stacks.add(new ItemStack((ItemLike)block));
                }
                CreativeModeTab tab = CreativeModeTab.builder().title((Component)Component.translatable((String)("itemGroup." + namespace + ".villagerpack_tab"))).icon(tabData::getIconItemStack).displayItems((parameters, output) -> output.acceptAll((Collection)stacks)).build();
                helper.register(VAPICreativeTabs.getTabId(namespace), (Object)tab);
                VillagerAPI.LOGGER.info("Registered creative tab for villagerpack '{}' with {} items", (Object)tabData.getDisplayName(), (Object)stacks.size());
            }
            catch (Exception e) {
                VillagerAPI.LOGGER.error("Failed to register creative tab for namespace '{}'", namespace, (Object)e);
            }
        }));
    }
}

