/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.mixin;

import com.frikinjay.villagerapi.villagerpack.BiomeTradesCache;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin {
    @Shadow
    public abstract VillagerData getVillagerData();

    @Inject(method={"updateTrades()V"}, at={@At(value="HEAD")})
    private void injectBiomeTrades(CallbackInfo ci) {
        Int2ObjectMap<VillagerTrades.ItemListing[]> mergedTrades;
        VillagerData villagerData = this.getVillagerData();
        VillagerProfession profession = villagerData.getProfession();
        VillagerType villagerType = villagerData.getType();
        if (BiomeTradesCache.hasBiomeTrades(profession) && (mergedTrades = BiomeTradesCache.getMergedTrades(profession, villagerType)) != null) {
            VillagerTrades.TRADES.put(profession, mergedTrades);
        }
    }
}

