/*
 * Decompiled with CFR 0.152.
 */
package com.frikinjay.villagerapi.mixin;

import com.frikinjay.villagerapi.VillagerAPI;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={VillagerTrades.EmeraldsForVillagerTypeItem.class})
public class EmeraldsForVillagerTypeItemMixin {
    @Shadow
    @Final
    private Map<VillagerType, Item> trades;
    @Shadow
    @Final
    private int cost;
    @Shadow
    @Final
    private int maxUses;
    @Shadow
    @Final
    private int villagerXp;

    @Inject(method={"getOffer(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/util/RandomSource;)Lnet/minecraft/world/item/trading/MerchantOffer;"}, at={@At(value="HEAD")}, cancellable=true)
    private void validateVillagerTypeItem(Entity entity, RandomSource randomSource, CallbackInfoReturnable<MerchantOffer> cir) {
        VillagerDataHolder villagerDataHolder;
        VillagerType villagerType;
        Item item;
        if (entity instanceof VillagerDataHolder && (item = this.trades.get(villagerType = (villagerDataHolder = (VillagerDataHolder)entity).getVillagerData().getType())) == null) {
            Item plainsItem = this.trades.get(VillagerType.PLAINS);
            if (plainsItem == null) {
                VillagerAPI.LOGGER.error("Villager type {} does not have a corresponding item in Firsherman's level 5 buy trade, and PLAINS fallback is also missing!", (Object)BuiltInRegistries.VILLAGER_TYPE.getKey((Object)villagerType));
                cir.setReturnValue(null);
            } else {
                VillagerAPI.LOGGER.debug("Villager type {} does not have a corresponding item in Firsherman's level 5 buy trade. Using PLAINS item {} instead.", (Object)BuiltInRegistries.VILLAGER_TYPE.getKey((Object)villagerType), (Object)BuiltInRegistries.ITEM.getKey((Object)plainsItem));
                ItemCost itemCost = new ItemCost((ItemLike)plainsItem, this.cost);
                MerchantOffer offer = new MerchantOffer(itemCost, new ItemStack((ItemLike)Items.EMERALD), this.maxUses, this.villagerXp, 0.05f);
                cir.setReturnValue((Object)offer);
            }
        }
    }
}

