/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.world.feature.features;

import com.aetherteam.aether.AetherTags;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import io.github.razordevs.deep_aether.init.DABlocks;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;

public class CloriteColumnsFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.WATER, (Object)Blocks.BEDROCK, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);

    public CloriteColumnsFeature(Codec<ColumnFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<ColumnFeatureConfiguration> pContext) {
        int i = pContext.chunkGenerator().getSeaLevel();
        BlockPos blockpos = pContext.origin();
        WorldGenLevel worldgenlevel = pContext.level();
        RandomSource randomsource = pContext.random();
        ColumnFeatureConfiguration columnfeatureconfiguration = (ColumnFeatureConfiguration)pContext.config();
        if (!CloriteColumnsFeature.canPlaceAt((LevelAccessor)worldgenlevel, blockpos.mutable())) {
            return false;
        }
        int j = columnfeatureconfiguration.height().sample(randomsource);
        boolean flag = randomsource.nextFloat() < 0.9f;
        int k = Math.min(j, flag ? 5 : 8);
        int l = flag ? 50 : 15;
        boolean flag1 = false;
        for (BlockPos blockpos1 : BlockPos.randomBetweenClosed((RandomSource)randomsource, (int)l, (int)(blockpos.getX() - k), (int)blockpos.getY(), (int)(blockpos.getZ() - k), (int)(blockpos.getX() + k), (int)blockpos.getY(), (int)(blockpos.getZ() + k))) {
            int i1 = j - blockpos1.distManhattan((Vec3i)blockpos);
            if (i1 < 0) continue;
            flag1 |= this.placeColumn((LevelAccessor)worldgenlevel, i, blockpos1, i1, columnfeatureconfiguration.reach().sample(randomsource));
        }
        return flag1;
    }

    /*
     * Unable to fully structure code
     */
    private boolean placeColumn(LevelAccessor pLevel, int pSeaLevel, BlockPos pPos, int pDistance, int pReach) {
        flag = false;
        var7 = BlockPos.betweenClosed((int)(pPos.getX() - pReach), (int)pPos.getY(), (int)(pPos.getZ() - pReach), (int)(pPos.getX() + pReach), (int)pPos.getY(), (int)(pPos.getZ() + pReach)).iterator();
        block0: while (true) {
            if (!var7.hasNext()) {
                return flag;
            }
            blockpos = (BlockPos)var7.next();
            i = blockpos.distManhattan((Vec3i)pPos);
            blockpos1 = CloriteColumnsFeature.isAirOrCloud(pLevel, blockpos) != false ? CloriteColumnsFeature.findSurface(pLevel, pSeaLevel, blockpos.mutable(), i) : CloriteColumnsFeature.findAir(pLevel, blockpos.mutable(), i);
            if (blockpos1 == null) continue;
            j = pDistance - i / 2;
            blockpos$mutableblockpos = blockpos1.mutable();
            while (true) {
                if (j < 0) continue block0;
                if (CloriteColumnsFeature.isAirOrCloud(pLevel, (BlockPos)blockpos$mutableblockpos)) {
                    this.setBlock((LevelWriter)pLevel, (BlockPos)blockpos$mutableblockpos, ((Block)DABlocks.CLORITE.get()).defaultBlockState());
                    blockpos$mutableblockpos.move(Direction.UP);
                    flag = true;
                } else {
                    if (pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).is((Block)DABlocks.CLORITE.get())) ** break;
                    continue block0;
                    blockpos$mutableblockpos.move(Direction.UP);
                }
                --j;
            }
            break;
        }
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor pLevel, int pSeaLevel, BlockPos.MutableBlockPos pPos, int pDistance) {
        while (pPos.getY() > pLevel.getMinBuildHeight() + 1 && pDistance > 0) {
            --pDistance;
            if (CloriteColumnsFeature.canPlaceAt(pLevel, pPos)) {
                return pPos;
            }
            pPos.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor pLevel, BlockPos.MutableBlockPos pPos) {
        if (!CloriteColumnsFeature.isAirOrCloud(pLevel, (BlockPos)pPos)) {
            return false;
        }
        BlockState blockstate = pLevel.getBlockState((BlockPos)pPos.move(Direction.DOWN));
        pPos.move(Direction.UP);
        return !blockstate.isAir() && !CANNOT_PLACE_ON.contains((Object)blockstate.getBlock());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor pLevel, BlockPos.MutableBlockPos pPos, int pDistance) {
        while (pPos.getY() < pLevel.getMaxBuildHeight() && pDistance > 0) {
            --pDistance;
            BlockState blockstate = pLevel.getBlockState((BlockPos)pPos);
            if (CANNOT_PLACE_ON.contains((Object)blockstate.getBlock())) {
                return null;
            }
            if (blockstate.isAir()) {
                return pPos;
            }
            pPos.move(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrCloud(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        return blockstate.isAir() || blockstate.is(AetherTags.Blocks.AERCLOUDS);
    }
}

