/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.recipe.jei;

import com.aetherteam.nitrogen.integration.jei.categories.AbstractRecipeCategory;
import io.github.razordevs.deep_aether.init.DABlocks;
import io.github.razordevs.deep_aether.recipe.combiner.CombinerRecipe;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CombinerRecipeCategory
extends AbstractRecipeCategory<CombinerRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"combiner_recipe");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"textures/gui/combiner_gui_jei.png");
    public static final ResourceLocation ARROW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"textures/gui/sprites/combiner_arrow.png");
    public static final RecipeType<CombinerRecipe> RECIPE_TYPE = RecipeType.create((String)"deep_aether", (String)"combiner_recipe", CombinerRecipe.class);
    private IDrawableAnimated animatedProgressArrow;

    public CombinerRecipeCategory(IGuiHelper guiHelper) {
        super("combiner_recipe", UID, (IDrawable)guiHelper.createDrawable(TEXTURE, 0, 0, 68, 58), guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)DABlocks.COMBINER.get())), RECIPE_TYPE);
        this.animatedProgressArrow = guiHelper.createAnimatedDrawable(guiHelper.drawableBuilder(ARROW_TEXTURE, 0, 0, 51, 14).setTextureSize(51, 14).build(), 100, IDrawableAnimated.StartDirection.TOP, false);
    }

    public Component getTitle() {
        return Component.translatable((String)("gui.deep_aether.jei." + this.id));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CombinerRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).addIngredients((Ingredient)recipe.getIngredients().getFirst());
        builder.addSlot(RecipeIngredientRole.INPUT, 26, 3).addIngredients((Ingredient)recipe.getIngredients().get(1));
        builder.addSlot(RecipeIngredientRole.INPUT, 49, 3).addIngredients((Ingredient)recipe.getIngredients().getLast());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 26, 39).addItemStack(recipe.getResult());
    }

    public void draw(CombinerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.animatedProgressArrow.draw(guiGraphics, 9, 22);
        this.drawCookingTime(guiGraphics, 50, 44, recipe.getProcessingTime());
    }

    private void drawCookingTime(GuiGraphics guiGraphics, int x, int y, int time) {
        if (time > 0) {
            int cookTimeSeconds = time / 20;
            MutableComponent timeString = Component.translatable((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font fontRenderer = Minecraft.getInstance().font;
            guiGraphics.drawString(fontRenderer, (Component)timeString, x, y, -8355712, false);
        }
    }
}

