/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.mixin.entity;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherPlayerAttachment;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.passive.Aerwhale;
import com.aetherteam.aether.item.AetherItems;
import io.github.razordevs.deep_aether.entity.AerwhaleSaddleable;
import io.github.razordevs.deep_aether.init.DAItems;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Aerwhale.class})
public abstract class AerwhaleMixin
extends FlyingMob
implements AerwhaleSaddleable,
ContainerEntity,
HasCustomInventoryScreen {
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_STILL_ID = SynchedEntityData.defineId(Aerwhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Unique
    private static final EntityDataAccessor<Boolean> DATA_SADDLE_ID = SynchedEntityData.defineId(Aerwhale.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Unique
    private NonNullList<ItemStack> deep_Aether$itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    @Unique
    @Nullable
    private ResourceKey<LootTable> deep_Aether$lootTable;
    @Unique
    private long deep_Aether$lootTableSeed;

    @Shadow(remap=false)
    public abstract void setYRotData(float var1);

    protected AerwhaleMixin(EntityType<? extends FlyingMob> p_20806_, Level p_20807_) {
        super(p_20806_, p_20807_);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    protected void defineSynchedData(SynchedEntityData.Builder builder, CallbackInfo ci) {
        builder.define(DATA_SADDLE_ID, (Object)false);
        builder.define(DATA_STILL_ID, (Object)false);
    }

    @Unique
    public boolean deep_Aether$isStill() {
        return (Boolean)this.getEntityData().get(DATA_STILL_ID);
    }

    @Unique
    public void deep_Aether$setStill(boolean isStill) {
        this.getEntityData().set(DATA_STILL_ID, (Object)isStill);
    }

    @Overwrite
    public void travel(@NotNull Vec3 vector) {
        if (this.deep_Aether$isStill()) {
            this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
        } else if (this.isEffectiveAi() || this.isControlledByLocalInstance()) {
            List passengers = this.getPassengers();
            if (!passengers.isEmpty()) {
                Entity entity = (Entity)passengers.getFirst();
                if (entity instanceof Player) {
                    float f4;
                    double d1;
                    double d0;
                    Player player = (Player)entity;
                    this.setYRot(player.getYRot() + 90.0f);
                    this.yRotO = player.getYHeadRot();
                    this.setXRot(-player.getXRot());
                    this.xRotO = player.getXRot() * 0.5f;
                    this.setYHeadRot(player.getYHeadRot());
                    this.yBodyRotO = player.getYHeadRot();
                    this.setYRotData(this.getYRot() - 90.0f);
                    float yRot = Mth.wrapDegrees((float)(this.getYRot() + 90.0f));
                    yRot = Mth.approachDegrees((float)yRot, (float)player.getYRot(), (float)1.0E-5f);
                    this.setYBodyRot(yRot);
                    vector = new Vec3((double)player.xxa, 0.0, player.zza <= 0.0f ? (double)(player.zza * 0.25f) : (double)player.zza);
                    if (((AetherPlayerAttachment)player.getData((Supplier)AetherDataAttachments.AETHER_PLAYER)).isJumping()) {
                        this.setDeltaMovement(new Vec3(0.0, 0.0, 0.0));
                    } else {
                        d0 = Math.toRadians(this.getYRot());
                        d1 = Math.toRadians(-player.getXRot());
                        double d2 = Math.cos(d1);
                        this.setDeltaMovement(0.98 * (this.getDeltaMovement().x() + 0.05 * Math.cos(d0) * d2), 0.98 * (this.getDeltaMovement().y() + 0.02 * Math.sin(d1)), 0.98 * (this.getDeltaMovement().z() + 0.05 * Math.sin(d0) * d2));
                    }
                    if (!this.level().isClientSide()) {
                        super.travel(vector);
                    }
                    if ((f4 = 4.0f * Mth.sqrt((float)((float)((d0 = this.getX() - this.xo) * d0 + (d1 = this.getZ() - this.zo) * d1)))) > 1.0f) {
                        f4 = 1.0f;
                    }
                    this.walkAnimation.update(f4, 0.4f);
                }
            } else {
                super.travel(vector);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"mobInteract"})
    protected void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (this.isSaddleable() && itemStack.is((Item)AetherItems.NATURE_STAFF.get())) {
            itemStack.hurtAndBreak(1, (LivingEntity)player, Objects.requireNonNull(itemStack.getEquipmentSlot()));
            this.deep_Aether$setStill(!this.deep_Aether$isStill());
            for (int i = 0; i < 20; ++i) {
                EntityUtil.spawnMovementExplosionParticles((Entity)this);
            }
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)this.level().isClientSide()));
        } else if (this.getPassengers().size() > 1) {
            cir.setReturnValue((Object)this.chestInteract(player));
        } else if (player.isSecondaryUseActive()) {
            cir.setReturnValue((Object)this.chestInteract(player));
        } else if (this.isSaddled()) {
            player.startRiding((Entity)this);
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)this.level().isClientSide()));
        }
    }

    @Unique
    private InteractionResult chestInteract(Player player) {
        InteractionResult interactionresult = this.interactWithContainerVehicle(player);
        if (interactionresult.consumesAction()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return interactionresult;
    }

    protected boolean canAddPassenger(Entity entity) {
        return this.getPassengers().size() < 2;
    }

    protected void positionRider(Entity entity, Entity.MoveFunction moveFunction) {
        int i = this.getPassengers().indexOf(entity);
        if (i >= 0) {
            boolean flag = i == 0;
            float f = 0.7f;
            float f1 = (float)(this.isRemoved() ? (double)0.01f : (double)this.getBbHeight() * 0.75);
            float f2 = 0.0f;
            if (this.level().isClientSide && ((Boolean)AetherConfig.CLIENT.legacy_models.get()).booleanValue()) {
                f1 += 1.7f;
                f -= 1.9f;
                f2 = 0.1f;
            }
            if (this.getPassengers().size() > 1 && !flag) {
                f = -1.2f;
            }
            if (i == 0) {
                f1 += 0.3f;
                f -= 0.1f;
            } else {
                f = -2.1f;
            }
            Vec3 vec3 = new Vec3(0.0, 0.0, (double)f).yRot(-this.yBodyRot * ((float)Math.PI / 180));
            moveFunction.accept(entity, this.getX() + vec3.x, this.getY() + (double)f1, this.getZ() + vec3.z + (double)f2);
            this.deep_Aether$clampRotation(entity);
        }
    }

    @Unique
    private void deep_Aether$clampRotation(Entity p_252070_) {
        p_252070_.setYBodyRot(this.getYRot());
        float f = p_252070_.getYRot();
        float f1 = Mth.wrapDegrees((float)(f - this.getYRot()));
        float f2 = Mth.clamp((float)f1, (float)-160.0f, (float)160.0f);
        p_252070_.yRotO += f2 - f1;
        float f3 = f + f2 - f1;
        p_252070_.setYRot(f3);
        p_252070_.setYHeadRot(f3);
    }

    @Override
    public boolean isSaddleable() {
        return this.isAlive();
    }

    @Override
    public void equipSaddle(@Nullable SoundSource source) {
        this.deep_Aether$setSaddled(true);
    }

    @Override
    public boolean isSaddled() {
        return (Boolean)this.getEntityData().get(DATA_SADDLE_ID);
    }

    @Unique
    public void deep_Aether$setSaddled(boolean isSaddled) {
        this.getEntityData().set(DATA_SADDLE_ID, (Object)isSaddled);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        this.addChestVehicleSaveData(tag, (HolderLookup.Provider)this.registryAccess());
        tag.putBoolean("isSaddled", this.isSaddled());
        tag.putBoolean("isStill", this.deep_Aether$isStill());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.readChestVehicleSaveData(tag, (HolderLookup.Provider)this.level().registryAccess());
        if (tag.contains("isSaddled")) {
            this.deep_Aether$setSaddled(tag.getBoolean("isSaddled"));
        }
        if (tag.contains("isStill")) {
            this.deep_Aether$setStill(tag.getBoolean("isStill"));
        }
    }

    public void die(@NotNull DamageSource damageSource) {
        super.die(damageSource);
        this.chestVehicleDestroyed(damageSource, this.level(), (Entity)this);
    }

    public void remove(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.RemovalReason reason) {
        if (!this.level().isClientSide && reason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(reason);
    }

    public void openCustomInventoryScreen(Player player) {
        player.openMenu((MenuProvider)this);
        if (!player.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)player);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
    }

    public NonNullList<ItemStack> getItemStacks() {
        return this.deep_Aether$itemStacks;
    }

    public void clearItemStacks() {
        this.deep_Aether$itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }

    public int getContainerSize() {
        return 27;
    }

    @NotNull
    public ItemStack getItem(int a) {
        return this.getChestVehicleItem(a);
    }

    @NotNull
    public ItemStack removeItem(int a, int b) {
        return this.removeChestVehicleItem(a, b);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int a) {
        return this.removeChestVehicleItemNoUpdate(a);
    }

    public void setItem(int a, @NotNull ItemStack b) {
        this.setChestVehicleItem(a, b);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return this.isChestVehicleStillValid(player);
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int a, Inventory inventory, Player player) {
        if (this.deep_Aether$lootTable != null && player.isSpectator()) {
            return null;
        }
        this.deep_Aether$unpackLootTable(inventory.player);
        return ChestMenu.threeRows((int)a, (Inventory)inventory, (Container)this);
    }

    @Unique
    public void deep_Aether$unpackLootTable(@Nullable Player player) {
        this.unpackChestVehicleLootTable(player);
    }

    @NotNull
    public SlotAccess getSlot(int a) {
        return this.getChestVehicleSlot(a);
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> lootTable) {
        this.deep_Aether$lootTable = lootTable;
    }

    public long getLootTableSeed() {
        return this.deep_Aether$lootTableSeed;
    }

    public void setLootTableSeed(long seed) {
        this.deep_Aether$lootTableSeed = seed;
    }

    public ResourceKey<LootTable> getLootTable() {
        return this.deep_Aether$lootTable;
    }

    protected void dropFromLootTable(DamageSource p_21021_, boolean p_21022_) {
        ResourceKey<LootTable> resourcekey = this.getLootTable();
        if (resourcekey == null) {
            return;
        }
        LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(resourcekey);
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)p_21021_).withOptionalParameter(LootContextParams.ATTACKING_ENTITY, (Object)p_21021_.getEntity()).withOptionalParameter(LootContextParams.DIRECT_ATTACKING_ENTITY, (Object)p_21021_.getDirectEntity());
        if (p_21022_ && this.lastHurtByPlayer != null) {
            lootparams$builder = lootparams$builder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)this.lastHurtByPlayer).withLuck(this.lastHurtByPlayer.getLuck());
        }
        LootParams lootparams = lootparams$builder.create(LootContextParamSets.ENTITY);
        loottable.getRandomItems(lootparams, this.getLootTableSeed(), arg_0 -> ((AerwhaleMixin)this).spawnAtLocation(arg_0));
    }

    protected void dropEquipment() {
        if (this.isSaddled()) {
            this.spawnAtLocation((ItemLike)DAItems.AERWHALE_SADDLE.get());
            this.deep_Aether$setSaddled(false);
        }
    }

    public void stopOpen(Player player) {
        this.level().gameEvent((Holder)GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.Context.of((Entity)player));
    }
}

