/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.misc;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.attachment.AetherTimeAttachment;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.aetherteam.aether.network.packet.clientbound.OpenSunAltarPacket;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class SunClock
extends Item {
    public SunClock(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand pUsedHand) {
        if (!level.isClientSide()) {
            if (((Boolean)AetherConfig.SERVER.sun_altar_whitelist.get()).booleanValue() && !player.hasPermissions(4) && !SunAltarWhitelist.INSTANCE.isWhiteListed(player.getGameProfile())) {
                player.displayClientMessage((Component)Component.translatable((String)"aether.sun_altar.no_permission"), true);
            } else if (level.dimension().location().toString().equals("aether:the_aether")) {
                if (level.hasData((Supplier)AetherDataAttachments.AETHER_TIME)) {
                    if (!((AetherTimeAttachment)level.getData((Supplier)AetherDataAttachments.AETHER_TIME)).isEternalDay()) {
                        this.openScreen(level, player, AetherTimeAttachment.getTicksPerDay());
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"aether.sun_altar.in_control"), true);
                    }
                } else {
                    this.openScreen(level, player, 24000);
                }
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"aether.sun_altar.no_power"), true);
            }
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(pUsedHand));
    }

    protected void openScreen(Level level, Player player, int timeScale) {
        if (!level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenSunAltarPacket((Component)Component.translatable((String)"menu.deep_aether.sun_clock"), timeScale), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public Component getDescription() {
        return Component.translatable((String)"deep_aether.item.disabled_item").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor((TextColor)TextColor.parseColor((String)"#d1362b").result().get()));
    }
}

