/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.misc;

import com.aetherteam.aether.entity.passive.Moa;
import io.github.razordevs.deep_aether.item.component.DADataComponentTypes;
import io.github.razordevs.deep_aether.item.component.MoaFodder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;

public class FodderItem
extends Item {
    public FodderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult interactLivingEntity(ItemStack itemStack, Player player, LivingEntity livingEntity, InteractionHand interactionHand) {
        if (!(livingEntity instanceof Moa)) {
            return InteractionResult.FAIL;
        }
        if (this.applyMoaEffect(livingEntity, itemStack)) {
            if (!player.isCreative()) {
                itemStack.shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (!pPlayer.isPassenger()) {
            return InteractionResultHolder.pass((Object)pPlayer.getItemInHand(pUsedHand));
        }
        Entity entity = pPlayer.getVehicle();
        if (entity instanceof Moa) {
            Moa moa = (Moa)entity;
            if (!pPlayer.isCreative()) {
                pPlayer.getItemInHand(pUsedHand).shrink(1);
            }
            this.applyMoaEffect((LivingEntity)moa, pPlayer.getItemInHand(pUsedHand));
            return InteractionResultHolder.consume((Object)pPlayer.getItemInHand(pUsedHand));
        }
        return InteractionResultHolder.pass((Object)pPlayer.getItemInHand(pUsedHand));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        MoaFodder fodder = (MoaFodder)stack.get(DADataComponentTypes.MOA_FODDER);
        if (fodder != null) {
            PotionContents.addPotionTooltip(List.of(fodder.effect()), tooltipComponents::add, (float)1.0f, (float)(context.level() == null ? 20.0f : context.tickRate()));
        }
    }

    private boolean applyMoaEffect(LivingEntity livingEntity, ItemStack stack) {
        MoaFodder fodder = (MoaFodder)stack.get(DADataComponentTypes.MOA_FODDER);
        if (fodder == null) {
            return false;
        }
        if (livingEntity.addEffect(fodder.effect())) {
            livingEntity.level().playLocalSound((Entity)livingEntity, SoundEvents.PLAYER_BURP, SoundSource.AMBIENT, 1.0f, 0.2f);
            return true;
        }
        return false;
    }

    public static MoaFodder getFodderEffect(ItemStack itemStack) {
        return (MoaFodder)itemStack.get(DADataComponentTypes.MOA_FODDER);
    }
}

