/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.misc;

import com.mojang.datafixers.util.Pair;
import io.github.razordevs.deep_aether.item.component.DADataComponentTypes;
import io.github.razordevs.deep_aether.item.component.DungeonTracker;
import io.github.razordevs.deep_aether.util.StructureUtil;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class DungeonCompass
extends Item {
    private final ResourceKey<Structure> dungeon;
    private final String dungeonName;

    public DungeonCompass(Item.Properties pProperties, ResourceKey<Structure> dungeon, String dungeonName) {
        super(pProperties);
        this.dungeon = dungeon;
        this.dungeonName = dungeonName;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack stack = playerIn.getItemInHand(hand);
        this.locateStructure(stack, playerIn);
        return super.use(worldIn, playerIn, hand);
    }

    private void locateStructure(ItemStack stack, Player player) {
        if (!player.level().isClientSide) {
            ServerLevel level = (ServerLevel)player.level();
            player.sendSystemMessage((Component)Component.translatable((String)"deep_aether.structure.locating", (Object[])new Object[]{this.dungeon}).withStyle(ChatFormatting.YELLOW));
            Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
            HolderSet featureHolderSet = registry.getHolder(this.dungeon).map(xva$0 -> HolderSet.direct((Holder[])new Holder[]{xva$0})).orElse(null);
            if (featureHolderSet != null) {
                Pair<BlockPos, Holder<Structure>> pair = StructureUtil.findNearestMapStructure(level, (HolderSet<Structure>)featureHolderSet, player.blockPosition(), 100, true);
                this.bindPosition(stack, player, (Level)level, pair);
            }
        }
    }

    private void bindPosition(ItemStack stack, Player player, Level level, Pair<BlockPos, Holder<Structure>> pair) {
        BlockPos structurePos;
        BlockPos blockPos = structurePos = pair != null ? (BlockPos)pair.getFirst() : null;
        if (structurePos == null) {
            stack.set(DADataComponentTypes.DUNGEON_TRACKER, (Object)new DungeonTracker(Optional.empty(), false));
            int range = 5000;
            player.sendSystemMessage((Component)Component.translatable((String)"deep_aether.structure.failed", (Object[])new Object[]{this.dungeonName, range}).withStyle(ChatFormatting.RED));
        } else {
            stack.set(DADataComponentTypes.DUNGEON_TRACKER, (Object)new DungeonTracker(Optional.of(GlobalPos.of((ResourceKey)level.dimension(), (BlockPos)((BlockPos)pair.getFirst()))), false));
            int distance = player.blockPosition().distManhattan((Vec3i)structurePos);
            player.sendSystemMessage((Component)Component.translatable((String)"deep_aether.structure.found", (Object[])new Object[]{this.dungeonName, distance}).withStyle(ChatFormatting.GREEN));
        }
        player.getCooldowns().addCooldown((Item)this, 1000);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        Level level = context.level();
        if (stack.has(DADataComponentTypes.DUNGEON_TRACKER)) {
            DungeonTracker tracker = (DungeonTracker)stack.get(DADataComponentTypes.DUNGEON_TRACKER);
            if (tracker != null && tracker.found()) {
                if (level != null && tracker.target().isPresent() && tracker.target().get().dimension().equals(level.dimension())) {
                    tooltip.add((Component)Component.translatable((String)"deep_aether.structure.found.tooltip", (Object[])new Object[]{this.dungeonName}).withStyle(ChatFormatting.GREEN));
                } else {
                    tooltip.add((Component)Component.translatable((String)"deep_aether.structure.wrong_dimension.tooltip", (Object[])new Object[]{this.dungeonName}).withStyle(ChatFormatting.RED));
                }
            } else {
                tooltip.add((Component)Component.translatable((String)"deep_aether.structure.failed.tooltip", (Object[])new Object[]{this.dungeonName}).withStyle(ChatFormatting.RED));
            }
        } else {
            tooltip.add((Component)Component.translatable((String)"deep_aether.structure.unset.tooltip").withStyle(ChatFormatting.GOLD));
        }
    }

    public Component getDescription() {
        return Component.translatable((String)"deep_aether.item.disabled_item").withStyle(Style.EMPTY.withItalic(Boolean.valueOf(true)).withColor((TextColor)TextColor.parseColor((String)"#d1362b").result().get()));
    }
}

