/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.item.gear.skyjade;

import com.aetherteam.aether.inventory.AetherAccessorySlots;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import io.github.razordevs.deep_aether.DeepAetherConfig;
import io.github.razordevs.deep_aether.init.DASounds;
import io.github.razordevs.deep_aether.item.gear.DAArmorMaterials;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class SkyjadeGlovesItem
extends GlovesItem {
    public SkyjadeGlovesItem(double punchDamage, Item.Properties properties) {
        super(DAArmorMaterials.SKYJADE, punchDamage, ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"skyjade_gloves"), DASounds.ITEM_ARMOR_EQUIP_SKYJADE, properties);
    }

    public void getDynamicModifiers(ItemStack stack, SlotReference reference, AccessoryAttributeBuilder builder) {
        if (!((Boolean)DeepAetherConfig.SERVER.enable_skyjade_rework.get()).booleanValue() && reference.slotName().equals(AetherAccessorySlots.GLOVES_SLOT_LOCATION.toString())) {
            builder.addStackable(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"deep_aether", (String)"gloves_damage_bonus"), (double)this.calculateIncrease(stack), AttributeModifier.Operation.ADD_VALUE));
        }
    }

    private float calculateIncrease(ItemStack stack) {
        int maxDurability = stack.getMaxDamage();
        int currentDurability = maxDurability - stack.getDamageValue();
        if (currentDurability >= maxDurability - (int)((double)maxDurability / 4.0)) {
            return 1.0f;
        }
        if (currentDurability >= maxDurability - (int)((double)maxDurability / 3.0)) {
            return 0.75f;
        }
        if (currentDurability >= maxDurability - (int)((double)maxDurability / 1.5)) {
            return 0.5f;
        }
        return 0.25f;
    }

    public boolean isEnchantable(ItemStack itemStack) {
        return (Boolean)DeepAetherConfig.SERVER.skyjade_enchant.get() != false && (Boolean)DeepAetherConfig.SERVER.enable_skyjade_rework.get() == false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return (Boolean)DeepAetherConfig.SERVER.skyjade_enchant.get() != false && (Boolean)DeepAetherConfig.SERVER.enable_skyjade_rework.get() == false;
    }
}

