/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.entity.living;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.monster.Zephyr;
import com.aetherteam.aether.entity.projectile.ZephyrSnowball;
import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BabyZephyr
extends Zephyr {
    public BabyZephyr(EntityType<? extends Zephyr> type, Level level) {
        super(type, level);
        this.moveControl = new BabyZephyrMoveControl(this);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(5, (Goal)new RandomFloatAroundGoal(this));
        this.goalSelector.addGoal(7, (Goal)new Zephyr.ZephyrLookGoal((Zephyr)this));
        this.goalSelector.addGoal(4, (Goal)new BabyZephyrMeeleGoal(this));
        this.goalSelector.addGoal(7, (Goal)new ZephyrShootSnowballGoal(this));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    protected void updateRandomPos() {
        RandomSource random = this.getRandom();
        double d0 = this.getX() + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
        double d1 = this.getY() + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
        double d2 = this.getZ() + (double)((random.nextFloat() * 2.0f - 1.0f) * 4.0f);
        this.getMoveControl().setWantedPosition(d0, d1, d2, 1.5);
    }

    protected static class BabyZephyrMoveControl
    extends MoveControl {
        private final BabyZephyr zephyr;
        private int floatDuration;

        public BabyZephyrMoveControl(BabyZephyr zephyr) {
            super((Mob)zephyr);
            this.zephyr = zephyr;
        }

        public void tick() {
            if (this.operation == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.zephyr.getRandom().nextInt(5) + 2;
                Vec3 vec3d = new Vec3(this.wantedX - this.zephyr.getX(), this.wantedY - this.zephyr.getY(), this.wantedZ - this.zephyr.getZ());
                double d0 = vec3d.length();
                if (this.canReach(vec3d = vec3d.normalize(), Mth.ceil((double)d0))) {
                    this.zephyr.setDeltaMovement(this.zephyr.getDeltaMovement().add(vec3d.scale(0.1 * this.speedModifier)));
                } else {
                    this.operation = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 pos, int distance) {
            AABB axisalignedbb = this.zephyr.getBoundingBox();
            for (int i = 1; i < distance; ++i) {
                axisalignedbb = axisalignedbb.move(pos);
                if (this.zephyr.level().noCollision((Entity)this.zephyr, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class RandomFloatAroundGoal
    extends Goal {
        private final BabyZephyr zephyr;

        public RandomFloatAroundGoal(BabyZephyr zephyr) {
            this.zephyr = zephyr;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            double d2;
            double d1;
            MoveControl moveControl = this.zephyr.getMoveControl();
            if (!moveControl.hasWanted()) {
                return true;
            }
            double d0 = moveControl.getWantedX() - this.zephyr.getX();
            double d3 = d0 * d0 + (d1 = moveControl.getWantedY() - this.zephyr.getY()) * d1 + (d2 = moveControl.getWantedZ() - this.zephyr.getZ()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean canContinueToUse() {
            return false;
        }

        public void start() {
            this.zephyr.updateRandomPos();
        }
    }

    public static class BabyZephyrMeeleGoal
    extends Goal {
        int cooldown = 20;
        int time = 0;
        private final BabyZephyr zephyr;
        private boolean hasAttacked = false;

        public BabyZephyrMeeleGoal(BabyZephyr zephyr) {
            this.zephyr = zephyr;
        }

        public boolean canUse() {
            if (this.zephyr.getTarget() == null || !this.zephyr.hasLineOfSight((Entity)this.zephyr.getTarget())) {
                return false;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.cooldown = this.zephyr.random.nextInt(20) + 20;
            return true;
        }

        public boolean canContinueToUse() {
            if (this.hasAttacked) {
                this.zephyr.updateRandomPos();
                return false;
            }
            if (this.time > 200) {
                return false;
            }
            LivingEntity livingentity = this.zephyr.getTarget();
            if (livingentity == null) {
                return false;
            }
            if (!livingentity.isAlive()) {
                return false;
            }
            if (this.zephyr.hurtTime > 0) {
                this.zephyr.updateRandomPos();
                return false;
            }
            return this.zephyr.isWithinRestriction(livingentity.blockPosition());
        }

        public void start() {
            this.time = 0;
            this.hasAttacked = false;
            if (this.zephyr.getTarget() != null) {
                Vec3 target = this.zephyr.getTarget().position().add(0.0, 2.0, 0.0);
                this.zephyr.getMoveControl().setWantedPosition(target.x(), target.y(), target.z(), 2.0);
            }
            this.zephyr.setAggressive(true);
        }

        public void stop() {
            LivingEntity livingentity = this.zephyr.getTarget();
            if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
                this.zephyr.setTarget(null);
            }
            this.zephyr.setAggressive(false);
            this.zephyr.updateRandomPos();
        }

        public void tick() {
            ++this.time;
            LivingEntity living = this.zephyr.getTarget();
            if (living != null) {
                Vec3 target = this.zephyr.getTarget().position().add(0.0, 2.0, 0.0);
                this.zephyr.getMoveControl().setWantedPosition(target.x(), target.y(), target.z(), 1.5 * (1.0 + (double)this.time / 100.0));
                if (this.zephyr.position().distanceToSqr(target) < (double)1.3f) {
                    living.hurt(this.zephyr.level().damageSources().mobAttack((LivingEntity)this.zephyr), 4.0f);
                    this.hasAttacked = true;
                }
            }
        }
    }

    protected static class ZephyrShootSnowballGoal
    extends Goal {
        private final BabyZephyr zephyr;

        public ZephyrShootSnowballGoal(BabyZephyr zephyr) {
            this.zephyr = zephyr;
        }

        public boolean canUse() {
            if (this.zephyr.isAggressive()) {
                return false;
            }
            return this.zephyr.getTarget() != null;
        }

        public void start() {
            this.zephyr.setChargeTime(0);
        }

        public void stop() {
            this.zephyr.setChargeTime(0);
        }

        public void tick() {
            LivingEntity livingEntity = this.zephyr.getTarget();
            if (livingEntity != null) {
                if (livingEntity.distanceToSqr((Entity)this.zephyr) < 1600.0 && this.zephyr.hasLineOfSight((Entity)livingEntity)) {
                    Level level = this.zephyr.level();
                    this.zephyr.setChargeTime(this.zephyr.getChargeTime() + 1);
                    if (this.zephyr.getChargeTime() == 2) {
                        if (this.zephyr.getAmbientSound() != null) {
                            this.zephyr.playSound(this.zephyr.getAmbientSound(), this.zephyr.getSoundVolume(), (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
                        }
                    } else if (this.zephyr.getChargeTime() == 12) {
                        Vec3 look = this.zephyr.getViewVector(1.0f);
                        double accelX = livingEntity.getX() - (this.zephyr.getX() + look.x() * 4.0);
                        double accelY = livingEntity.getY(0.5) - (0.5 + this.zephyr.getY(0.5));
                        double accelZ = livingEntity.getZ() - (this.zephyr.getZ() + look.z() * 4.0);
                        this.zephyr.playSound((SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_SHOOT.get(), this.zephyr.getSoundVolume(), (level.getRandom().nextFloat() - level.getRandom().nextFloat()) * 0.2f + 1.0f);
                        ZephyrSnowball snowball = new ZephyrSnowball(level, (LivingEntity)this.zephyr, accelX * 2.0, accelY * 2.0, accelZ * 2.0);
                        snowball.setPos(this.zephyr.getX() + look.x() * 4.0, this.zephyr.getY(0.5) + 0.5, this.zephyr.getZ() + look.z() * 4.0);
                        level.addFreshEntity((Entity)snowball);
                        this.zephyr.setChargeTime(-1);
                    }
                } else if (this.zephyr.getChargeTime() > 0) {
                    this.zephyr.setChargeTime(this.zephyr.getChargeTime() - 1);
                }
            }
        }
    }
}

