/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import io.github.razordevs.deep_aether.entity.living.AerglowFish;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class AerglowFishModel
extends EntityModel<AerglowFish> {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart fin_left;
    private final ModelPart fin_right;

    public AerglowFishModel(ModelPart root) {
        this.body = root.getChild("body");
        this.head = root.getChild("head");
        this.fin_left = root.getChild("fin_left");
        this.fin_right = root.getChild("fin_right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 4.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        body.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(29, 4).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        body.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(24, 4).addBox(0.0f, 0.0f, -1.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)7.0f));
        tail.addOrReplaceChild("tail_sub_0", CubeListBuilder.create().texOffs(22, 3).mirror().addBox(0.0f, -2.0f, 0.0f, 0.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)2.0f));
        body.addOrReplaceChild("fin_back", CubeListBuilder.create().texOffs(20, -6).addBox(0.0f, -2.0f, -1.0f, 0.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(13, 0).addBox(-1.0f, -2.0f, -3.0f, 2.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)0.0f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -2.0f, -1.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)-3.0f));
        partdefinition.addOrReplaceChild("fin_left", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("fin_right", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(AerglowFish entity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = 1.0f;
        float f1 = 1.0f;
        if (!entity.isInWater()) {
            f = 1.3f;
            f1 = 1.7f;
        }
        this.body.yRot = -f * 0.25f * Mth.sin((float)(f1 * 0.6f * pAgeInTicks));
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.body.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.head.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.fin_left.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.fin_right.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

