/*
 * Decompiled with CFR 0.152.
 */
package io.github.razordevs.deep_aether.block.utility;

import com.mojang.serialization.MapCodec;
import io.github.razordevs.deep_aether.entity.block.CombinerBlockEntity;
import io.github.razordevs.deep_aether.init.DABlockEntityTypes;
import io.github.razordevs.deep_aether.init.DABlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class CombinerBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<CombinerBlock> CODEC = CombinerBlock.simpleCodec(CombinerBlock::new);
    public static final BooleanProperty CHARGING = DABlockStateProperties.COMBINER_CHARGING;
    public static final BooleanProperty COMBINING = DABlockStateProperties.COMBINER_COMBINING;

    public CombinerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)CHARGING, (Comparable)Boolean.valueOf(false))).setValue((Property)COMBINING, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CHARGING, COMBINING});
    }

    protected MapCodec<? extends CombinerBlock> codec() {
        return CODEC;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof CombinerBlockEntity) {
            ((CombinerBlockEntity)blockEntity).drops();
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
    }

    protected void openContainer(Level level, BlockPos blockPos, Player player) {
        BlockEntity entity;
        if (!level.isClientSide() && (entity = level.getBlockEntity(blockPos)) instanceof CombinerBlockEntity) {
            player.openMenu((MenuProvider)((CombinerBlockEntity)entity));
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return CombinerBlock.createTicker(level, blockEntityType, (BlockEntityType<? extends CombinerBlockEntity>)((BlockEntityType)DABlockEntityTypes.COMBINER.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level level, BlockEntityType<T> serverType, BlockEntityType<? extends CombinerBlockEntity> clientType) {
        return level.isClientSide() ? null : CombinerBlock.createTickerHelper(serverType, clientType, CombinerBlockEntity::serverTick);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CombinerBlockEntity(blockPos, blockState);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }
}

